/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.migration;

import com.sybase.ua.migration.MigrationException;
import com.sybase.ua.migration.MigrationTask;
import java.util.ArrayList;
import java.util.List;

public class MigrationManager {
    private static MigrationManager instance = null;
    private final List migrationTasks = new ArrayList(1);

    public static MigrationManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new MigrationManager();
        return instance;
    }

    private MigrationManager() {
    }

    public void addMigrationTask(MigrationTask task) {
        this.migrationTasks.add(task);
    }

    public void apply(Class migrationTaskClass) throws MigrationException {
        for (MigrationTask task : this.migrationTasks) {
            if (!task.getClass().getName().equals(migrationTaskClass.getName())) continue;
            task.apply();
        }
    }

    public void applyAll() throws MigrationException {
        for (MigrationTask task : this.migrationTasks) {
            task.apply();
        }
    }

    public List getMigrationTasks() {
        return this.migrationTasks;
    }
}

