/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.migration;

import com.sybase.ua.migration.MalformatVersionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    public static final String MIN_VERSION = "0.0.0";
    public static final String MAX_VERSION = "999.999.999";
    private String versionAsString;
    private int majorNumber;
    private int minorNumber;
    private int milestoneNumber;
    private int versionAsInteger;

    public static int compareVersions(String version, String version2) {
        try {
            return Version.compareVersions(Version.createVersion(version), Version.createVersion(version2));
        }
        catch (MalformatVersionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static int compareVersions(Version version, String version2) {
        try {
            return Version.compareVersions(version, Version.createVersion(version2));
        }
        catch (MalformatVersionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static int compareVersions(Version version, Version version2) {
        return version.compare(version2);
    }

    public static Version createVersion(String version) throws MalformatVersionException {
        String re = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
        Pattern pattern = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new MalformatVersionException("Not a valid version string: " + version);
        }
        Version versionObject = new Version();
        String majorString = matcher.group(1);
        String minorString = matcher.group(2);
        String milestoneString = matcher.group(3);
        versionObject.versionAsString = version;
        versionObject.majorNumber = new Integer(majorString);
        versionObject.minorNumber = new Integer(minorString);
        versionObject.milestoneNumber = new Integer(milestoneString);
        versionObject.versionAsInteger = versionObject.majorNumber * 1000000 + versionObject.minorNumber * 1000 + versionObject.milestoneNumber;
        return versionObject;
    }

    public static Version createVersion(int major, int minor, int milestone) {
        Version v = new Version();
        v.majorNumber = major;
        v.minorNumber = minor;
        v.milestoneNumber = milestone;
        v.versionAsInteger = v.majorNumber * 1000000 + v.minorNumber * 1000 + v.milestoneNumber;
        v.versionAsString = String.format("%d.%d.%d", v.majorNumber, v.minorNumber, v.milestoneNumber);
        return v;
    }

    private Version() {
    }

    public int compare(Version anotherVersion) {
        return this.getVersionAsInteger() - anotherVersion.getVersionAsInteger();
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public int getMilestoneNumber() {
        return this.milestoneNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public int getVersionAsInteger() {
        return this.versionAsInteger;
    }

    public String getVersionAsString() {
        return this.versionAsString;
    }

    public String toString() {
        return this.getVersionAsString();
    }
}

