/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.migration.tasks;

import com.sybase.ua.config.ARLConfigRuleSet;
import com.sybase.ua.config.ARLWriter;
import com.sybase.ua.config.AgentConfig;
import com.sybase.ua.config.AgentConfigWriter;
import com.sybase.ua.config.AgentServiceConfig;
import com.sybase.ua.config.AgentServiceConfigRuleSet;
import com.sybase.ua.config.AgentServiceConfigWriter;
import com.sybase.ua.migration.AbstractMigrationPatch;
import com.sybase.ua.migration.MalformatVersionException;
import com.sybase.ua.migration.Migratable;
import com.sybase.ua.migration.MigrationException;
import com.sybase.ua.migration.Version;
import com.sybase.ua.migration.VersionRange;
import com.sybase.ua.security.ac.ARL;
import com.sybase.ua.security.ac.AttributeARL;
import com.sybase.ua.security.ac.OperationARL;
import com.sybase.ua.security.ac.PermissionARL;
import com.sybase.ua.security.ac.RoleARL;
import com.sybase.ua.util.DigesterUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSetBase;

public class AgentConfigMigrationPatch_1_0_1_to_2_0_0
extends AbstractMigrationPatch {
    public static final String VERSION_AFTER_MIGRATION = "2.0.0";
    public static final String VERSION_BEFORE_MIGRATION = "1.5.0";
    public static final String SERVICE_CONFIG_XML_VERSION = "2.0.0";
    public static final String MIGRATION_BACKUP_EXTENSION = "migration";
    public static final String DEFAULT_PROVIDER_NAME = "Sybase, Inc.";
    private File agentHome;

    private static Object parseXml(File xml, File dtd, String dtdPublicId, RuleSetBase ruleSet, ClassLoader classloader) throws Exception {
        Digester configDigester = null;
        try {
            configDigester = DigesterUtil.initDigester(dtd, dtdPublicId, ruleSet, classloader);
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize digester: " + dtd.getAbsolutePath(), e);
        }
        Object obj = null;
        try {
            obj = DigesterUtil.parse(configDigester, xml);
        }
        catch (Throwable t) {
            throw new Exception("Failed to parse XML: " + xml.getAbsolutePath(), t);
        }
        finally {
            configDigester.clear();
        }
        return obj;
    }

    public AgentConfigMigrationPatch_1_0_1_to_2_0_0(Migratable migratableComponent) {
        super(migratableComponent);
    }

    public File getAgentHome() {
        return this.agentHome;
    }

    @Override
    public String getDescription() {
        String desc = "Migrating services from UAF v1 to UAF v2.";
        return "Migrating services from UAF v1 to UAF v2.";
    }

    @Override
    public VersionRange getMigrationConditionVersionRange() throws MalformatVersionException {
        VersionRange sourceRange = new VersionRange("0.0.0", "1.9.9");
        return sourceRange;
    }

    @Override
    public Version getVersionAfterMigration() throws MalformatVersionException {
        Version version = Version.createVersion("2.0.0");
        return version;
    }

    public void setAgentHome(File agentHome) {
        this.agentHome = agentHome;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    protected void doInstall(Migratable migratableComponent) throws MigrationException {
        if (!(migratableComponent instanceof AgentConfig)) {
            throw new MigrationException("Migratable component is not instance of AgentConfig.");
        }
        AgentConfig agentConfig = (AgentConfig)migratableComponent;
        List<AgentServiceConfig> serviceConfigs = agentConfig.getAgentServices().getServices();
        int numberOfServices = serviceConfigs.size();
        String oldVersion = agentConfig.getXmlVersion();
        this.log.info((Object)("There are " + numberOfServices + " services needed to be migrated from UAF v" + oldVersion + " to UAF v" + "2.0.0" + "..."));
        for (AgentServiceConfig serviceConfig : serviceConfigs) {
            this.updateMissingProperties(serviceConfig);
            String serviceId = serviceConfig.getId();
            try {
                this.log.info((Object)("Migrating service " + serviceId));
                this.doMigrateService(serviceConfig);
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                } else {
                    this.log.error((Object)e.getMessage());
                }
                throw new MigrationException("Failed to migrate service " + serviceId + ": " + e.getMessage(), e);
            }
        }
        agentConfig.setXmlVersion("2.0.0");
        AgentConfigWriter agentConfigWriter = new AgentConfigWriter(agentConfig, this.agentHome);
        try {
            agentConfigWriter.saveConfig("migration." + oldVersion);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update agent-config.xml.");
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            this.log.error((Object)e.getMessage());
        }
        this.log.info((Object)("Successfully migrated " + numberOfServices + " services to UAF v" + "2.0.0"));
    }

    @Override
    protected void doPostInstall(Migratable migratableComponent) throws MigrationException {
    }

    private void doMigrateService(AgentServiceConfig serviceConfig) throws Exception {
        String mbeanDescriptorRelativePath = serviceConfig.getMbeanDescriptor();
        File mbeanDescriptorXml = new File(this.getAgentHome(), mbeanDescriptorRelativePath);
        File serviceDir = mbeanDescriptorXml.getParentFile();
        String arlRelativePath = serviceConfig.getArlConfig();
        File arlXml = new File(this.getAgentHome(), arlRelativePath);
        String arlXmlPath = arlXml.getAbsolutePath();
        String arlDtdPath = arlXmlPath.substring(0, arlXmlPath.lastIndexOf(".")) + ".dtd";
        File arlDTD = new File(arlDtdPath);
        File serviceConfigXml = new File(serviceDir, "service-config.xml");
        File serviceConfigDtd = new File(serviceDir, "service-config.dtd");
        this.validateServiceDir(serviceDir, mbeanDescriptorXml, arlXml, serviceConfigXml, serviceConfigDtd);
        this.updateServiceConfigXml(serviceConfig, serviceConfigXml, serviceConfigDtd, serviceDir);
        this.updateArlXml(serviceConfig, arlXml, arlDTD, serviceDir);
    }

    private void updateArlXml(AgentServiceConfig oldServiceConfig, File arlXml, File arlDtd, File serviceDir) throws Exception {
        ARL arl = (ARL)AgentConfigMigrationPatch_1_0_1_to_2_0_0.parseXml(arlXml, arlDtd, null, new ARLConfigRuleSet(), this.getClass().getClassLoader());
        PermissionARL readPerm = new PermissionARL();
        readPerm.setName("read");
        PermissionARL writePerm = new PermissionARL();
        writePerm.setName("write");
        PermissionARL executePerm = new PermissionARL();
        executePerm.setName("execute");
        RoleARL uaAgentAdminRoleRWPerm = new RoleARL();
        uaAgentAdminRoleRWPerm.setName("uaAgentAdmin");
        uaAgentAdminRoleRWPerm.addPermission(readPerm);
        uaAgentAdminRoleRWPerm.addPermission(writePerm);
        RoleARL uaAgentAdminRoleReadPerm = new RoleARL();
        uaAgentAdminRoleReadPerm.setName("uaAgentAdmin");
        uaAgentAdminRoleReadPerm.addPermission(readPerm);
        RoleARL uaAgentAdminRoleExecPerm = new RoleARL();
        uaAgentAdminRoleExecPerm.setName("uaAgentAdmin");
        uaAgentAdminRoleExecPerm.addPermission(executePerm);
        RoleARL uaAnonymousRole = new RoleARL();
        uaAnonymousRole.setName("uaAnonymous");
        uaAnonymousRole.addPermission(readPerm);
        RoleARL uaPluginAdminRole = new RoleARL();
        uaPluginAdminRole.setName("uaPluginAdmin");
        uaPluginAdminRole.addPermission(readPerm);
        RoleARL uaASEAdminRole = new RoleARL();
        uaASEAdminRole.setName("uaASEAdmin");
        uaASEAdminRole.addPermission(readPerm);
        AttributeARL versionAttrib = new AttributeARL();
        versionAttrib.setName("version");
        versionAttrib.addRole(uaAgentAdminRoleReadPerm);
        versionAttrib.addRole(uaAnonymousRole);
        versionAttrib.addRole(uaPluginAdminRole);
        versionAttrib.addRole(uaASEAdminRole);
        AttributeARL providerNameAttrib = new AttributeARL();
        providerNameAttrib.setName("providerName");
        providerNameAttrib.addRole(uaAgentAdminRoleRWPerm);
        providerNameAttrib.addRole(uaAnonymousRole);
        providerNameAttrib.addRole(uaPluginAdminRole);
        providerNameAttrib.addRole(uaASEAdminRole);
        AttributeARL referenceCountAttrib = new AttributeARL();
        referenceCountAttrib.setName("referenceCount");
        referenceCountAttrib.addRole(uaAgentAdminRoleReadPerm);
        referenceCountAttrib.addRole(uaAnonymousRole);
        referenceCountAttrib.addRole(uaPluginAdminRole);
        referenceCountAttrib.addRole(uaASEAdminRole);
        AttributeARL referenceListAttrib = new AttributeARL();
        referenceListAttrib.setName("referenceList");
        referenceListAttrib.addRole(uaAgentAdminRoleReadPerm);
        referenceListAttrib.addRole(uaAnonymousRole);
        referenceListAttrib.addRole(uaPluginAdminRole);
        referenceListAttrib.addRole(uaASEAdminRole);
        AttributeARL registerOnStartupAttrib = new AttributeARL();
        registerOnStartupAttrib.setName("registerOnStartup");
        registerOnStartupAttrib.addRole(uaAgentAdminRoleRWPerm);
        registerOnStartupAttrib.addRole(uaAnonymousRole);
        registerOnStartupAttrib.addRole(uaPluginAdminRole);
        registerOnStartupAttrib.addRole(uaASEAdminRole);
        AttributeARL serviceHomeAttrib = new AttributeARL();
        serviceHomeAttrib.setName("serviceHome");
        serviceHomeAttrib.addRole(uaAgentAdminRoleReadPerm);
        serviceHomeAttrib.addRole(uaAnonymousRole);
        serviceHomeAttrib.addRole(uaPluginAdminRole);
        serviceHomeAttrib.addRole(uaASEAdminRole);
        AttributeARL dependenciesAttrib = new AttributeARL();
        dependenciesAttrib.setName("dependencies");
        dependenciesAttrib.addRole(uaAgentAdminRoleRWPerm);
        dependenciesAttrib.addRole(uaAnonymousRole);
        dependenciesAttrib.addRole(uaPluginAdminRole);
        dependenciesAttrib.addRole(uaASEAdminRole);
        if (!arl.containsAttribute(versionAttrib.getName())) {
            arl.addAttributeARL(versionAttrib);
        }
        if (!arl.containsAttribute(providerNameAttrib.getName())) {
            arl.addAttributeARL(providerNameAttrib);
        }
        if (!arl.containsAttribute(referenceCountAttrib.getName())) {
            arl.addAttributeARL(referenceCountAttrib);
        }
        if (!arl.containsAttribute(referenceListAttrib.getName())) {
            arl.addAttributeARL(referenceListAttrib);
        }
        if (!arl.containsAttribute(registerOnStartupAttrib.getName())) {
            arl.addAttributeARL(registerOnStartupAttrib);
        }
        if (!arl.containsAttribute(serviceHomeAttrib.getName())) {
            arl.addAttributeARL(serviceHomeAttrib);
        }
        if (!arl.containsAttribute(dependenciesAttrib.getName())) {
            arl.addAttributeARL(dependenciesAttrib);
        }
        OperationARL decrementReferenceCountOpArl = new OperationARL();
        decrementReferenceCountOpArl.setName("decrementReferenceCount");
        decrementReferenceCountOpArl.setSignature("");
        decrementReferenceCountOpArl.addRole(uaAgentAdminRoleExecPerm);
        OperationARL incrementReferenceCountOpArl = new OperationARL();
        incrementReferenceCountOpArl.setName("incrementReferenceCount");
        incrementReferenceCountOpArl.setSignature("");
        incrementReferenceCountOpArl.addRole(uaAgentAdminRoleExecPerm);
        if (!arl.containsOperation(decrementReferenceCountOpArl.getName(), decrementReferenceCountOpArl.getSignature())) {
            arl.addOperationARL(decrementReferenceCountOpArl);
        }
        if (!arl.containsOperation(incrementReferenceCountOpArl.getName(), incrementReferenceCountOpArl.getSignature())) {
            arl.addOperationARL(incrementReferenceCountOpArl);
        }
        ARLWriter arlWriter = new ARLWriter(arl, arlXml);
        arlWriter.saveConfig("migration.1.5.0");
    }

    private void updateMissingProperties(AgentServiceConfig serviceConfig) {
        String classname = serviceConfig.getClassName();
        int idx = classname.lastIndexOf(".");
        String id = classname.substring(idx + 1);
        serviceConfig.setId(id);
        serviceConfig.setVersion("2.0.0");
        serviceConfig.setRegisterOnStartup(true);
        serviceConfig.setProviderName(DEFAULT_PROVIDER_NAME);
    }

    private void updateServiceConfigXml(AgentServiceConfig oldServiceConfig, File serviceConfigXml, File serviceConfigDtd, File serviceDir) throws Exception {
        Map<String, Object> oldProps = oldServiceConfig.getProperties().getProperties();
        AgentServiceConfig newServiceConfig = (AgentServiceConfig)AgentConfigMigrationPatch_1_0_1_to_2_0_0.parseXml(serviceConfigXml, serviceConfigDtd, "-//Sybase Unified Agent Framework Service Configuration//DTD service-config 2.0.0//EN", new AgentServiceConfigRuleSet(), this.getClass().getClassLoader());
        newServiceConfig.setName(oldServiceConfig.getName());
        Iterator<String> i$ = oldProps.keySet().iterator();
        while (i$.hasNext()) {
            String string;
            String name = string = i$.next();
            String value = oldProps.get(name).toString();
            newServiceConfig.addProperty(name, value);
        }
        newServiceConfig.setVersion("2.0.0");
        String oldVersion = oldServiceConfig.getVersion();
        AgentServiceConfigWriter serviceConfigWriter = new AgentServiceConfigWriter(newServiceConfig, serviceDir);
        serviceConfigWriter.saveConfig("migration." + oldVersion);
    }

    private void validateServiceDir(File serviceDir, File mbeanDescriptorXml, File arlXml, File serviceConfigXml, File serviceConfigDtd) throws Exception {
        if (!serviceDir.exists() || !serviceDir.isDirectory()) {
            throw new Exception("Service directory does not exist: " + serviceDir.getAbsolutePath());
        }
        if (!mbeanDescriptorXml.exists()) {
            throw new Exception("MBean descriptor doesn't exist: " + mbeanDescriptorXml.getAbsolutePath());
        }
        if (!arlXml.exists()) {
            throw new Exception("ARL XML doesn't exist: " + arlXml.getAbsolutePath());
        }
        if (!serviceConfigXml.exists()) {
            throw new Exception("Service config XML doesn't exist: " + serviceConfigXml.getAbsolutePath());
        }
        if (!serviceConfigDtd.exists()) {
            throw new Exception("Service config DTD doesn't exist: " + serviceConfigDtd.getAbsolutePath());
        }
    }
}

