/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.migration.tasks;

import com.sybase.ua.config.AdaptorConfig;
import com.sybase.ua.config.AgentConfig;
import com.sybase.ua.config.AgentServiceConfig;
import com.sybase.ua.migration.AbstractMigrationPatch;
import com.sybase.ua.migration.MalformatVersionException;
import com.sybase.ua.migration.Migratable;
import com.sybase.ua.migration.MigrationException;
import com.sybase.ua.migration.Version;
import com.sybase.ua.migration.VersionRange;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AgentConfigMigrationPatch_to_1_0_1
extends AbstractMigrationPatch {
    public static final String VERSION_AFTER_MIGRATION = "1.0.1";

    public AgentConfigMigrationPatch_to_1_0_1(Migratable migratableComponent) {
        super(migratableComponent);
    }

    @Override
    public String getDescription() {
        String desc = "Migrating agent configuration XML file from v1.0.0 to v1.0.1.";
        return "Migrating agent configuration XML file from v1.0.0 to v1.0.1.";
    }

    @Override
    public VersionRange getMigrationConditionVersionRange() throws MalformatVersionException {
        VersionRange sourceRange = new VersionRange("0.0.0", "1.0.0");
        return sourceRange;
    }

    @Override
    public Version getVersionAfterMigration() throws MalformatVersionException {
        Version version = Version.createVersion(VERSION_AFTER_MIGRATION);
        return version;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    protected void doInstall(Migratable migratableComponent) throws MigrationException {
        if (!(migratableComponent instanceof AgentConfig)) {
            throw new MigrationException("Migratable component is not instance of AgentConfig.");
        }
        AgentConfig agentConfig = (AgentConfig)migratableComponent;
        List<AgentServiceConfig> serviceConfigs = agentConfig.getAgentServices().getServices();
        for (AgentServiceConfig serviceConfig : serviceConfigs) {
            if (!serviceConfig.getClassName().equals("com.sybase.ua.services.discovery.SelfDiscoveryService")) continue;
            this.doMigrateSelfDiscoveryService(serviceConfig);
            break;
        }
    }

    @Override
    protected void doPostInstall(Migratable migratableComponent) throws MigrationException {
    }

    private void doMigrateSelfDiscoveryService(AgentServiceConfig discoveryServiceConfig) {
        Map<String, Object> props = discoveryServiceConfig.getProperties().getProperties();
        String adaptorClass = (String)props.get("adaptor");
        if (adaptorClass != null && !adaptorClass.trim().equals("")) {
            AdaptorConfig adaptorConfig = new AdaptorConfig();
            adaptorConfig.setClassname(adaptorClass);
            adaptorConfig.setId(adaptorClass);
            Set<String> keys = props.keySet();
            for (String propKey : keys) {
                if (propKey.equals("adaptor")) continue;
                String propValue = (String)props.get(propKey);
                adaptorConfig.addProperty(propKey, propValue);
            }
            discoveryServiceConfig.addAdaptor(adaptorConfig);
        }
        discoveryServiceConfig.getProperties().getProperties().clear();
    }
}

