/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.migration.tasks;

import com.sybase.ua.config.AgentConfig;
import com.sybase.ua.config.AgentConfigRuleSet_1_5_0;
import com.sybase.ua.migration.AbstractMigrationTask;
import com.sybase.ua.migration.tasks.AgentConfigMigrationPatch_1_0_1_to_2_0_0;
import com.sybase.ua.migration.tasks.AgentConfigMigrationPatch_to_1_0_1;
import com.sybase.ua.startup.Startup;
import com.sybase.ua.util.DigesterUtil;
import java.io.File;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentConfigMigrationTask
extends AbstractMigrationTask {
    public static final String MIGRATABLE_COMPONENT_NAME = "Agent Configuration XML";
    private static Log log = LogFactory.getLog(AgentConfigMigrationTask.class);

    public AgentConfigMigrationTask() throws Exception {
        File agentHome = this.getAgentHome();
        AgentConfig agentConfig = this.parseAgentConfigXml(agentHome);
        AgentConfigMigrationPatch_to_1_0_1 patch_to_1_0_1 = new AgentConfigMigrationPatch_to_1_0_1(agentConfig);
        this.addPatch(patch_to_1_0_1);
        AgentConfigMigrationPatch_1_0_1_to_2_0_0 patch_1_0_1_to_2_0_0 = new AgentConfigMigrationPatch_1_0_1_to_2_0_0(agentConfig);
        patch_1_0_1_to_2_0_0.setAgentHome(agentHome);
        this.addPatch(patch_1_0_1_to_2_0_0);
    }

    @Override
    public String getMigratableComponentName() {
        return MIGRATABLE_COMPONENT_NAME;
    }

    private File getAgentHome() {
        File agentHomeDir = null;
        String agentHomeProp = System.getProperty("com.sybase.ua.home");
        if (agentHomeProp != null) {
            agentHomeDir = new File(agentHomeProp);
        } else {
            String codebase = Startup.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            File codebaseFile = new File(codebase);
            agentHomeDir = codebaseFile.getParentFile().getParentFile().getParentFile();
        }
        return agentHomeDir;
    }

    private AgentConfig parseAgentConfigXml(File agentHome) throws Exception {
        Digester configDigester = null;
        File confDir = new File(agentHome, "conf");
        File xml = new File(confDir, "agent-config.xml");
        File dtd = new File(confDir, "agent-config.dtd");
        String dtdPublicId = "-//simon.sybase.com//DTD UnifiedAgent Configuration 1.0//EN";
        try {
            configDigester = DigesterUtil.initDigester(dtd, "-//simon.sybase.com//DTD UnifiedAgent Configuration 1.0//EN", new AgentConfigRuleSet_1_5_0());
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize digester: " + dtd.getAbsolutePath(), e);
        }
        AgentConfig agentConfig = null;
        try {
            agentConfig = (AgentConfig)DigesterUtil.parse(configDigester, xml);
        }
        catch (Throwable t) {
            throw new Exception("Failed to parse XML " + xml.getAbsolutePath() + ". " + t.getMessage(), t);
        }
        finally {
            configDigester.clear();
        }
        return agentConfig;
    }
}

