/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.plugin;

import com.sybase.ua.plugin.AgentPluginMBean;
import com.sybase.ua.services.Agent;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginAutoUnregisterThread
extends Thread {
    private static Log log = LogFactory.getLog(PluginAutoUnregisterThread.class);
    private static final String PLUGIN_REGISTRATION_SERVICE_ID = "PluginRegisterService";
    private AgentPluginMBean pluginMBean;
    private final int gracePeriod;
    private boolean running = false;

    public PluginAutoUnregisterThread(AgentPluginMBean pluginMBean, int gracePeriod) {
        super("PluginAutoUnregisterThread");
        this.pluginMBean = pluginMBean;
        this.gracePeriod = gracePeriod;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        this.setRunning(true);
        List<PluginAutoUnregisterThread> autoUnregisterThreads = this.pluginMBean.getAutoUnregisterThreadList();
        if (autoUnregisterThreads.size() > 0) {
            for (PluginAutoUnregisterThread thread : autoUnregisterThreads) {
                thread.setRunning(false);
                thread.interrupt();
            }
        }
        this.pluginMBean.addAutoUnregisterThread(this);
        if (this.gracePeriod > 0) {
            try {
                Thread.sleep(this.gracePeriod * 60000);
            }
            catch (InterruptedException e) {
                this.setRunning(false);
            }
        }
        if (this.isRunning()) {
            int refCount = this.pluginMBean.getReferenceCount();
            if (refCount == 0) {
                try {
                    if (Agent.getInstance().isAgentServiceAvailable(PLUGIN_REGISTRATION_SERVICE_ID)) {
                        Agent.getInstance().invokeAgentServiceMethod(PLUGIN_REGISTRATION_SERVICE_ID, "unregisterPlugin", new Object[]{this.pluginMBean.getMBeanName()}, new String[]{"java.lang.String"});
                    }
                    log.info((Object)("Plugin " + this.pluginMBean.toString() + " is automatically unregistered."));
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    log.error((Object)e.getMessage());
                }
            }
            this.setRunning(false);
        }
        this.pluginMBean.removeAutoUnregisterThread(this);
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }

    protected void finalize() throws Throwable {
        this.pluginMBean = null;
        super.finalize();
    }
}

