/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.plugin;

import com.sybase.ua.config.AgentPluginConfig;
import com.sybase.ua.config.AgentPluginConfigRuleSet;
import com.sybase.ua.loader.ClassLoaderFactory;
import com.sybase.ua.loader.PluginClassLoader;
import com.sybase.ua.plugin.AgentPluginException;
import com.sybase.ua.services.Agent;
import com.sybase.ua.util.DigesterUtil;
import java.io.File;
import org.apache.commons.digester.Digester;

public class PluginMetaInfo {
    private File pluginDirectory;
    private transient PluginClassLoader pluginClassLoader;
    private AgentPluginConfig pluginConfig;
    public static final String DEFAULT_MBEAN_DESCRIPTOR_XML = "mbean-descriptor.xml";

    public PluginMetaInfo(File pluginDirectory) throws AgentPluginException {
        this.pluginDirectory = pluginDirectory;
        this.validateDirectoryStructure();
        this.createClassLoader();
        this.parsePluginConfig();
        this.validateDirectoryStructure2();
        this.setClassLoaderInfo();
    }

    public PluginClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    public AgentPluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }

    public void setPluginConfig(AgentPluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    public String toString() {
        return this.pluginConfig.getId() + "_" + this.pluginConfig.getVersion();
    }

    protected void finalize() throws Throwable {
        this.pluginDirectory = null;
        this.pluginClassLoader = null;
        this.pluginConfig = null;
        super.finalize();
    }

    private void createClassLoader() throws AgentPluginException {
        try {
            this.pluginClassLoader = ClassLoaderFactory.createPluginClassLoader(Agent.getInstance().getAgentHome(), this.pluginDirectory.getAbsolutePath(), Agent.getInstance().getSharedClassLoader());
        }
        catch (Exception e) {
            throw new AgentPluginException("Failed to create PluginClassLoader.", e);
        }
    }

    private void parsePluginConfig() throws AgentPluginException {
        File configXML = new File(this.pluginDirectory, "agent-plugin.xml");
        File configDTD = new File(this.pluginDirectory, "agent-plugin.dtd");
        Digester configDigester = null;
        try {
            configDigester = DigesterUtil.initDigester(configDTD, "-//simon.sybase.com//DTD Unified Agent Plugin Configuration 1.0//EN", new AgentPluginConfigRuleSet(), this.pluginClassLoader);
        }
        catch (Exception e) {
            throw new AgentPluginException("Failed to init digester: " + configDTD.getAbsolutePath(), e);
        }
        try {
            this.pluginConfig = (AgentPluginConfig)DigesterUtil.parse(configDigester, configXML);
        }
        catch (Throwable t) {
            String msg = "Failed to parse XML: " + configXML.getAbsolutePath() + ". The file is probably corrupted. Please restore it from the backup.";
            throw new AgentPluginException(msg, t);
        }
        finally {
            configDigester.clear();
        }
    }

    private void setClassLoaderInfo() {
        if (this.pluginClassLoader != null) {
            this.pluginClassLoader.setPluginName(this.pluginConfig.getId());
            this.pluginClassLoader.setPluginVersion(this.pluginConfig.getVersion());
        }
    }

    private void validateDirectoryStructure() throws AgentPluginException {
        if (!this.pluginDirectory.exists() || !this.pluginDirectory.isDirectory()) {
            throw new AgentPluginException("Plugin directory not found: " + this.pluginDirectory.getName());
        }
        if (!this.pluginDirectory.canRead()) {
            throw new AgentPluginException("Plugin directory " + this.pluginDirectory.getName() + " is not readable.");
        }
        File pluginConfigFile = new File(this.pluginDirectory, "agent-plugin.xml");
        if (!pluginConfigFile.exists() || pluginConfigFile.isDirectory()) {
            throw new AgentPluginException(this.pluginDirectory.getName() + ": plugin configuration file " + "agent-plugin.xml" + " not found. The plugin directory will be ignored.");
        }
        File pluginConfigDTD = new File(this.pluginDirectory, "agent-plugin.dtd");
        if (!pluginConfigDTD.exists() || pluginConfigDTD.isDirectory()) {
            throw new AgentPluginException("Plugin configuration DTD file agent-plugin.dtd not found. The plugin directory will be ignored.");
        }
    }

    private void validateDirectoryStructure2() throws AgentPluginException {
        if (this.pluginConfig != null) {
            File arlConfig;
            String arl = this.pluginConfig.getArlConfig();
            if (arl != null && (!(arlConfig = new File(this.pluginDirectory, arl)).exists() || arlConfig.isDirectory())) {
                throw new AgentPluginException("ARL configuration file " + arl + " not found. The plugin directory will be ignored.");
            }
            String mbeanType = this.pluginConfig.getMbeanType();
            if (mbeanType != null && mbeanType.equalsIgnoreCase("Model MBean")) {
                File mbeanDescriptor;
                String mbeanDescriptorXml = this.pluginConfig.getMbeanDescriptor();
                if (mbeanDescriptorXml == null) {
                    mbeanDescriptorXml = DEFAULT_MBEAN_DESCRIPTOR_XML;
                }
                if (!(mbeanDescriptor = new File(this.pluginDirectory, mbeanDescriptorXml)).exists() || mbeanDescriptor.isDirectory()) {
                    throw new AgentPluginException("MBean descriptor XML file " + mbeanDescriptorXml + " not found. The plugin directory will be ignored.");
                }
            }
        }
    }
}

