/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security;

import com.sybase.ua.security.ResourceURL;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Pre30ResourceURL {
    private static final String RESOURCE_TYPE = "type";
    private static final String RESOURCE_PATH = "path";
    private static Log log = LogFactory.getLog(Pre30ResourceURL.class);
    private String resourceType;
    private String resourcePath;

    public static String convertResourceURL(ResourceURL resURL) {
        String ret = null;
        String domain = resURL.getResourceDomain();
        ObjectName oname = resURL.getResourceObjectName();
        ResourceURL.ResourceFieldType type = resURL.getResourceFieldType();
        if (domain.equals("AgentService")) {
            String serviceId = oname.getKeyProperty("name");
            if (type == ResourceURL.ResourceFieldType.ATTRIBUTE) {
                String attribName = resURL.getResourcePath();
                ret = Pre30ResourceURL.createServiceAttributeResourceURL(serviceId, attribName).toString();
            } else if (type == ResourceURL.ResourceFieldType.METHOD) {
                String[] pathArray = resURL.getResourcePathElements();
                String operationName = pathArray[0];
                String signature = pathArray.length > 1 ? pathArray[1] : null;
                ret = Pre30ResourceURL.createServiceOperationResourceURL(serviceId, operationName, signature).toString();
            } else {
                log.error((Object)("Unsupported type in URL: " + resURL));
            }
        } else if (domain.equals("AgentPlugin")) {
            String pluginVersionId = oname.getKeyProperty("name");
            String[] pluginNameElements = pluginVersionId.split("_");
            String pluginId = pluginNameElements[0];
            String pluginVersion = pluginNameElements[1];
            String instanceNumber = pluginNameElements[2];
            if (type == ResourceURL.ResourceFieldType.ATTRIBUTE) {
                String attribName = resURL.getResourcePath();
                ret = Pre30ResourceURL.createPluginAttributeResourceURL(pluginId, pluginVersion, Integer.parseInt(instanceNumber), attribName).toString();
            } else if (type == ResourceURL.ResourceFieldType.METHOD) {
                String[] pathArray = resURL.getResourcePathElements();
                String operationName = pathArray[0];
                String signature = pathArray.length > 1 ? pathArray[1] : null;
                ret = Pre30ResourceURL.createPluginOperationResourceURL(pluginId, pluginVersion, Integer.parseInt(instanceNumber), operationName, signature).toString();
            } else {
                log.error((Object)("Unsupported type in URL: " + resURL));
            }
        } else {
            log.error((Object)("Unsupported domain: " + domain));
        }
        return ret;
    }

    private static Pre30ResourceURL createPluginAttributeResourceURL(String pluginId, String pluginVersion, int instanceNumber, String attribName) {
        String instanceNumberString = new Integer(instanceNumber).toString();
        String resPath = pluginId + "_" + pluginVersion + "_" + instanceNumberString + "/" + attribName;
        return Pre30ResourceURL.createResourceURL("PLUGIN_PROPERTY", resPath);
    }

    private static Pre30ResourceURL createPluginOperationResourceURL(String pluginId, String pluginVersion, int instanceNumber, String operationName, String signature) {
        String instanceNumberString = new Integer(instanceNumber).toString();
        String sig = "";
        if (signature != null) {
            sig = signature;
        }
        String resPath = pluginId + "_" + pluginVersion + "_" + instanceNumberString + "/" + operationName + "/" + sig;
        return Pre30ResourceURL.createResourceURL("PLUGIN_METHOD", resPath);
    }

    private static Pre30ResourceURL createResourceURL(String resType, String resPath) {
        Pre30ResourceURL resUrl = new Pre30ResourceURL();
        resUrl.setResourceType(resType);
        resUrl.setResourcePath(resPath);
        return resUrl;
    }

    private static Pre30ResourceURL createServiceAttributeResourceURL(String serviceId, String attribName) {
        String resPath = serviceId + "/" + attribName;
        return Pre30ResourceURL.createResourceURL("SERVICE_PROPERTY", resPath);
    }

    private static Pre30ResourceURL createServiceOperationResourceURL(String serviceId, String operationName, String signature) {
        String sig = "";
        if (signature != null) {
            sig = signature;
        }
        String resPath = serviceId + "/" + operationName + "/" + sig;
        return Pre30ResourceURL.createResourceURL("SERVICE_METHOD", resPath);
    }

    private Pre30ResourceURL() {
    }

    public String toString() {
        return this.getURL();
    }

    private String getURL() {
        String url = "type=" + this.resourceType + "&" + RESOURCE_PATH + "=" + this.resourcePath;
        return url;
    }

    private void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    private void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }
}

