/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security;

import com.sybase.ua.security.ac.AttributeARL;
import com.sybase.ua.security.ac.OperationARL;
import com.sybase.ua.util.AgentClientUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceURL
implements Comparable<ResourceURL> {
    private static Log log = LogFactory.getLog(ResourceURL.class);
    public static final String RESOURCE_PATH_SEPARATOR = "/";
    public static final String RESOURCE_URL_ELEMENT_SEPARATOR = "&";
    private static final String RESOURCE_OBJECT_NAME = "objectName";
    private static final String RESOURCE_FIELD_TYPE = "type";
    private static final String RESOURCE_PATH = "path";
    public static final List<String> UAF_REQ_OBJNAME_PROPS = Arrays.asList("name");
    public static final List<String> MO_REQ_OBJNAME_PROPS = Arrays.asList("pm", "type");
    private final ResourceFieldType _resourceFieldType;
    private final ObjectName _resourceObjectName;
    private final String _resourcePath;
    private transient String _cachedResourceUrlString = null;
    private ResourceURL _resourceTypeUrl = null;

    @Deprecated
    public static ResourceURL createPluginAttributeResourceURL(String pluginId, String pluginVersion, int instanceNumber, String attribName) {
        try {
            return ResourceURL.createResourceURL(AgentClientUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber), attribName);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Failed to create ObjectName with pluginID=" + pluginId + "_" + pluginVersion + "_" + instanceNumber);
        }
    }

    @Deprecated
    public static ResourceURL createPluginOperationResourceURL(String pluginId, String pluginVersion, int instanceNumber, String operationName, String signature) {
        try {
            String[] signatureArray = signature != null ? signature.split(",") : new String[]{};
            return ResourceURL.createResourceURL(ResourceFieldType.METHOD, AgentClientUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber), operationName, signatureArray);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Failed to create ObjectName with pluginID=" + pluginId + "_" + pluginVersion + "_" + instanceNumber);
        }
    }

    public static ResourceURL createResourceURL(ObjectName objectName) {
        return new ResourceURL(objectName);
    }

    public static ResourceURL createResourceURL(ObjectName objectName, AttributeARL attributeARL) {
        return new ResourceURL(ResourceFieldType.ATTRIBUTE, objectName, attributeARL.getName());
    }

    public static ResourceURL createResourceURL(ObjectName oname, OperationARL operationARL) {
        return new ResourceURL(ResourceFieldType.METHOD, oname, ResourceURL.buildResourceURLPath(operationARL));
    }

    public static ResourceURL createResourceURL(ObjectName objectName, String attributeName) {
        return new ResourceURL(ResourceFieldType.ATTRIBUTE, objectName, attributeName);
    }

    public static ResourceURL createResourceURL(ObjectName objectName, String operationName, String ... paramTypes) {
        return ResourceURL.createResourceURL(ResourceFieldType.METHOD, objectName, operationName, paramTypes);
    }

    public static ResourceURL createResourceURL(ObjectName objectName, String operationName, Class<?> ... paramTypes) {
        return ResourceURL.createResourceURL(ResourceFieldType.METHOD, objectName, operationName, paramTypes);
    }

    public static <T extends Member> ResourceURL createResourceURL(ObjectName objectName, T member) {
        if (member instanceof Field) {
            return new ResourceURL(ResourceFieldType.ATTRIBUTE, objectName, ResourceURL.buildResourceURLPath((Field)member));
        }
        if (member instanceof Method) {
            String resPath = member != null ? ResourceURL.buildResourceURLPath(member.getName(), ((Method)member).getParameterTypes()) : "";
            return new ResourceURL(ResourceFieldType.METHOD, objectName, resPath);
        }
        if (member instanceof Constructor) {
            String resPath = member != null ? ResourceURL.buildResourceURLPath(member.getName(), ((Constructor)member).getParameterTypes()) : "";
            return new ResourceURL(ResourceFieldType.CONSTRUCTOR, objectName, resPath);
        }
        String resPath = "";
        return new ResourceURL(ResourceFieldType.CLASS, objectName, "");
    }

    public static ResourceURL createResourceURL(ResourceFieldType type, ObjectName objectName, String name, Class<?>[] paramTypes) {
        return new ResourceURL(type, objectName, ResourceURL.buildResourceURLPath(name, paramTypes));
    }

    public static ResourceURL createResourceURL(ResourceFieldType type, ObjectName objectName, String name, String[] paramTypes) {
        return new ResourceURL(type, objectName, ResourceURL.buildResourceURLPath(name, paramTypes));
    }

    public static ResourceURL createResourceURL(String resUrl) {
        try {
            return ResourceURL.doCreateResourceURL(resUrl);
        }
        catch (IllegalArgumentException iae) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to parse resource url string using new format.  Attempting old format.  Message=(" + iae.getMessage() + ")"));
            }
            try {
                return OldStyleResourceURL.createResourceURL(resUrl);
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Failed to parse resource url string using both new format and old format.  Message=(" + iae.getMessage() + ")"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"ResourceURL syntax error", (Throwable)iae);
                        log.debug((Object)"ResourceURL syntax error", (Throwable)e);
                    }
                }
                throw iae;
            }
        }
    }

    @Deprecated
    public static ResourceURL createServiceAttributeResourceURL(String serviceId, String attribName) {
        try {
            return ResourceURL.createResourceURL(AgentClientUtil.getServiceObjectName(serviceId), attribName);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Failed to create ObjectName with serviceID=" + serviceId);
        }
    }

    @Deprecated
    public static ResourceURL createServiceOperationResourceURL(String serviceId, String operationName, String signature) {
        try {
            String[] signatureArray = signature != null ? signature.split(",") : new String[]{};
            return ResourceURL.createResourceURL(ResourceFieldType.METHOD, AgentClientUtil.getServiceObjectName(serviceId), operationName, signatureArray);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Failed to create ObjectName with serviceID=" + serviceId);
        }
    }

    static String buildResourceURLPath(Field f) {
        return f != null ? f.getName() : "";
    }

    static String buildResourceURLPath(Method m) {
        if (m == null) {
            return "";
        }
        return ResourceURL.buildResourceURLPath(m.getName(), m.getParameterTypes());
    }

    static String buildResourceURLPath(OperationARL op) {
        return op.getName() + RESOURCE_PATH_SEPARATOR + op.getSignature();
    }

    static String buildResourceURLPath(String operationName, Class<?>[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        StringBuilder sig = new StringBuilder();
        for (int i = 0; i < paramTypes.length; ++i) {
            sig.append(paramTypes[i].getName());
            if (i + 1 >= paramTypes.length) continue;
            sig.append(',');
        }
        return operationName + RESOURCE_PATH_SEPARATOR + sig.toString();
    }

    static String buildResourceURLPath(String operationName, String[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new String[]{};
        }
        StringBuilder sig = new StringBuilder();
        for (int i = 0; i < paramTypes.length; ++i) {
            sig.append(paramTypes[i].trim());
            if (i + 1 >= paramTypes.length) continue;
            sig.append(',');
        }
        return operationName + RESOURCE_PATH_SEPARATOR + sig.toString();
    }

    private static ResourceURL doCreateResourceURL(String resUrl) {
        String msg;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building ResourceURL from string: " + resUrl));
        }
        String[] tokens = resUrl.split(RESOURCE_URL_ELEMENT_SEPARATOR);
        HashMap<String, String> tokenMap = new HashMap<String, String>(5, 1.0f);
        for (String token : tokens) {
            int eqindex = token.indexOf("=", 0);
            String key = token.substring(0, eqindex);
            String value = token.substring(eqindex + 1);
            tokenMap.put(key, value);
        }
        String resTypeStr = (String)tokenMap.get(RESOURCE_FIELD_TYPE);
        String onameStr = (String)tokenMap.get(RESOURCE_OBJECT_NAME);
        String pathStr = (String)tokenMap.get(RESOURCE_PATH);
        if (resTypeStr == null) {
            msg = "Resource URL '" + resUrl + "' does not contain the required '" + RESOURCE_FIELD_TYPE + "' key";
            throw new IllegalArgumentException(msg);
        }
        if (onameStr == null) {
            msg = "Resource URL '" + resUrl + "' does not contain the required '" + RESOURCE_FIELD_TYPE + "' key";
            throw new IllegalArgumentException(msg);
        }
        try {
            ResourceFieldType resType = ResourceFieldType.valueOf(resTypeStr.toUpperCase());
            ObjectName oname = ObjectName.getInstance(onameStr);
            return new ResourceURL(resType, oname, pathStr);
        }
        catch (MalformedObjectNameException mone) {
            log.error((Object)("Resource URL '" + resUrl + "' does not contain a valid ObjectName"), (Throwable)mone);
            throw new IllegalArgumentException("Resource URL '" + resUrl + "' does not contain a valid ObjectName");
        }
    }

    protected ResourceURL(ObjectName objectName) {
        this(ResourceFieldType.CLASS, objectName, "");
    }

    protected ResourceURL(ResourceFieldType resourceType, ObjectName objectName, String path) {
        this._resourceFieldType = resourceType;
        this._resourceObjectName = objectName;
        this._resourcePath = path;
        ObjectName resTypeObjectName = this.normalizeResourceTypeObjectName(objectName);
        this._resourceTypeUrl = !objectName.equals(resTypeObjectName) ? new ResourceURL(this._resourceFieldType, resTypeObjectName, this._resourcePath) : this;
    }

    public int compareResourceTypes(ResourceURL o) {
        return this.getResourceTypeUrl().compareTo(o.getResourceTypeUrl());
    }

    @Override
    public int compareTo(ResourceURL o) {
        return this.getURL().compareTo(o.getURL());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceURL other = (ResourceURL)obj;
        if (this._resourceObjectName == null ? other._resourceObjectName != null : !this._resourceObjectName.equals(other._resourceObjectName)) {
            return false;
        }
        if (this._resourceFieldType == null ? other._resourceFieldType != null : !this._resourceFieldType.equals((Object)other._resourceFieldType)) {
            return false;
        }
        return !(this._resourcePath == null ? other._resourcePath != null : (ResourceFieldType.ATTRIBUTE.equals((Object)this._resourceFieldType) ? !this._resourcePath.equalsIgnoreCase(other._resourcePath) : !this._resourcePath.equals(other._resourcePath)));
    }

    public String getResourceDomain() {
        return this._resourceObjectName.getDomain();
    }

    public ResourceFieldType getResourceFieldType() {
        return this._resourceFieldType;
    }

    public ObjectName getResourceObjectName() {
        return this._resourceObjectName;
    }

    public String getResourcePath() {
        return this._resourcePath;
    }

    public String[] getResourcePathElements() {
        return this.getResourcePath().split(RESOURCE_PATH_SEPARATOR);
    }

    public ResourceURL getResourceTypeUrl() {
        return this._resourceTypeUrl;
    }

    public String getURL() {
        if (this._cachedResourceUrlString == null) {
            this._cachedResourceUrlString = "objectName=" + this._resourceObjectName + RESOURCE_URL_ELEMENT_SEPARATOR + RESOURCE_FIELD_TYPE + "=" + (Object)((Object)this._resourceFieldType) + RESOURCE_URL_ELEMENT_SEPARATOR + RESOURCE_PATH + "=" + this._resourcePath;
        }
        return this._cachedResourceUrlString;
    }

    public int hashCode() {
        String path;
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._resourceObjectName == null ? 0 : this._resourceObjectName.hashCode());
        String string = path = this._resourcePath != null ? this._resourcePath : "";
        path = this._resourceFieldType == null ? path : (this._resourceFieldType.equals((Object)ResourceFieldType.ATTRIBUTE) ? path.toLowerCase() : path);
        result = 31 * result + (this._resourcePath == null ? 0 : path.hashCode());
        result = 31 * result + (this._resourceFieldType == null ? 0 : this._resourceFieldType.hashCode());
        return result;
    }

    public boolean isResourceTypeUrl() {
        return this._resourceTypeUrl == this;
    }

    public String toString() {
        return this.getURL();
    }

    protected ObjectName normalizeResourceTypeObjectName(ObjectName objectName) {
        StringBuilder sb = new StringBuilder();
        String domain = objectName.getDomain();
        sb.append(domain).append(":");
        Hashtable<String, String> ht = objectName.getKeyPropertyList();
        if (domain.equals("AgentPlugin") || domain.equals("AgentService")) {
            if (!ht.containsKey("name")) {
                throw new IllegalArgumentException("The objectName does not contain the required 'name' property'");
            }
            sb.append("name=").append(ht.get("name"));
        } else if (domain.equals("ManagedObject")) {
            Iterator<String> ki = MO_REQ_OBJNAME_PROPS.iterator();
            while (ki.hasNext()) {
                String k = ki.next();
                if (!ht.containsKey(k)) {
                    throw new IllegalArgumentException("The objectName does not contain the required '" + k + "' property.");
                }
                sb.append(k).append("=").append(ht.get(k));
                if (!ki.hasNext()) continue;
                sb.append(",");
            }
        } else {
            Iterator<String> ki = MO_REQ_OBJNAME_PROPS.iterator();
            while (ki.hasNext()) {
                String k = ki.next();
                if (!ht.containsKey(k)) continue;
                sb.append(k).append("=").append(ht.get(k));
                if (!ki.hasNext()) continue;
                sb.append(",");
            }
        }
        try {
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Failed to build a valid resource type ObjectName from the normalized object name string");
        }
    }

    @Deprecated
    private static class OldStyleResourceURL {
        public static final String TYPE_PLUGIN = "PLUGIN";
        public static final String TYPE_SERVICE = "SERVICE";
        public static final String TYPE_PLUGIN_METHOD = "PLUGIN_METHOD";
        public static final String TYPE_PLUGIN_PROPERTY = "PLUGIN_PROPERTY";
        public static final String TYPE_SERVICE_METHOD = "SERVICE_METHOD";
        public static final String TYPE_SERVICE_PROPERTY = "SERVICE_PROPERTY";

        private OldStyleResourceURL() {
        }

        public static ResourceURL createResourceURL(String resUrl) {
            int idx1 = resUrl.indexOf("type=");
            int idx2 = idx1 + "type=".length();
            int idx3 = resUrl.indexOf(ResourceURL.RESOURCE_URL_ELEMENT_SEPARATOR, idx2);
            String resType = resUrl.substring(idx2, idx3);
            int idx4 = idx3 + ResourceURL.RESOURCE_URL_ELEMENT_SEPARATOR.length();
            int idx5 = resUrl.indexOf("path=", idx4);
            int idx6 = idx5 + "path=".length();
            String resPath = resUrl.substring(idx6);
            ResourceFieldType type = null;
            if (resType.equals(TYPE_PLUGIN_METHOD) || resType.equals(TYPE_SERVICE_METHOD)) {
                type = ResourceFieldType.METHOD;
            } else if (resType.equals(TYPE_PLUGIN_PROPERTY) || resType.equals(TYPE_SERVICE_PROPERTY)) {
                type = ResourceFieldType.ATTRIBUTE;
            } else {
                throw new IllegalArgumentException("Unsupported resource url type argument");
            }
            String[] pathElements = resPath.split(ResourceURL.RESOURCE_PATH_SEPARATOR);
            ObjectName oname = null;
            try {
                if (resType.startsWith(TYPE_SERVICE)) {
                    oname = AgentClientUtil.getServiceObjectName(pathElements[0]);
                } else if (resType.startsWith(TYPE_PLUGIN)) {
                    String[] pluginNameElements = pathElements[0].split("_");
                    String pluginId = pluginNameElements[0];
                    String pluginVersion = pluginNameElements[1];
                    String instanceNumber = pluginNameElements[2];
                    oname = AgentClientUtil.getPluginObjectName(pluginId, pluginVersion, Integer.valueOf(instanceNumber));
                }
            }
            catch (MalformedObjectNameException mone) {
                throw new IllegalArgumentException("Failed to create ObjectName with resource path=" + resPath);
            }
            StringBuilder newPath = new StringBuilder();
            for (int i = 1; i < pathElements.length; ++i) {
                newPath.append(pathElements[i]);
                if (i + 1 >= pathElements.length) continue;
                newPath.append(ResourceURL.RESOURCE_PATH_SEPARATOR);
            }
            if (type.equals((Object)ResourceFieldType.METHOD) && pathElements.length == 2) {
                newPath.append(ResourceURL.RESOURCE_PATH_SEPARATOR);
            }
            return new ResourceURL(type, oname, newPath.toString());
        }
    }

    public static enum ResourceFieldType {
        CLASS,
        ATTRIBUTE,
        METHOD,
        CONSTRUCTOR;

    }
}

