/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security.ac;

import com.sybase.ua.security.ac.AttributeARL;
import com.sybase.ua.security.ac.OperationARL;
import com.sybase.ua.security.ac.PermissionARL;
import com.sybase.ua.security.ac.PermissionValue;
import com.sybase.ua.security.ac.RoleARL;
import com.sybase.ua.security.ac.SecurityModule;
import com.sybase.ua.util.CollectionUtil;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class ARL
implements Serializable {
    static final long serialVersionUID = 2863639314245791587L;
    private String mbeanName;
    private String defaultSecurityModule;
    private List<AttributeARL> attributesARL = new ArrayList<AttributeARL>(5);
    private List<OperationARL> operationsARL = new ArrayList<OperationARL>(5);
    private List<PermissionValue> attributePermissionValues = new ArrayList<PermissionValue>(3);
    private List<PermissionValue> operationPermissionValues = new ArrayList<PermissionValue>(2);
    public static final String XML_ELEMENT_ROOT = "access-requirements";
    public static final String XML_ELEMENT_MBEAN = "mbean";
    public static final String XML_ELEMENT_MBEAN_ATTRIBUTE_NAME = "name";
    public static final String XML_ELEMENT_MBEAN_ATTRIBUTE_DEFAULT_SEC_MODULE = "default-security-module";
    public static final String XML_ELEMENT_ATTRIBUTES = "attributes";
    public static final String XML_ELEMENT_PERMISSION_VALUE = "permission-value";
    public static final String XML_ELEMENT_PERMISSION_VALUE_ATTRIBUTE_NAME = "name";
    public static final String XML_ELEMENT_PERMISSION_VALUE_ATTRIBUTE_ABBREVIATION = "abbreviation";
    public static final String XML_ELEMENT_PERMISSION_VALUE_ATTRIBUTE_DESCRIPTION = "description";
    public static final String XML_ELEMENT_ATTRIBUTE = "attribute";
    public static final String XML_ELEMENT_ATTRIBUTE_ATTRIBUTE_NAME = "name";
    public static final String XML_ELEMENT_SECURITY_MODULES = "security-modules";
    public static final String XML_ELEMENT_MODULE = "module";
    public static final String XML_ELEMENT_MODULE_NAME = "name";
    public static final String XML_ELEMENT_ROLE = "role";
    public static final String XML_ELEMENT_ROLE_ATTRIBUTE_NAME = "name";
    public static final String XML_ELEMENT_PERMISSION = "permission";
    public static final String XML_ELEMENT_PERMISSION_ATTRIBUTE_NAME = "name";
    public static final String XML_ELEMENT_OPERATIONS = "operations";
    public static final String XML_ELEMENT_OPERATION = "operation";
    public static final String XML_ELEMENT_OPERATION_ATTRIBUTE_NAME = "name";
    public static final String XML_ELEMENT_OPERATION_ATTRIBUTE_SIGNATURE = "signature";

    public void addAttributeARL(AttributeARL attribARL) {
        this.attributesARL.add(attribARL);
    }

    public void addAttributePermissionValue(PermissionValue permValue) {
        this.attributePermissionValues.add(permValue);
    }

    public void addOperationARL(OperationARL opARL) {
        this.operationsARL.add(opARL);
    }

    public void addOperationPermissionValue(PermissionValue permValue) {
        this.operationPermissionValues.add(permValue);
    }

    public boolean containsAttribute(String attributeName) {
        boolean contains = false;
        for (AttributeARL attribArl : this.attributesARL) {
            if (!attribArl.getName().equals(attributeName)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public boolean containsOperation(String operationName, String signature) {
        boolean contains = false;
        for (OperationARL operationArl : this.operationsARL) {
            if (!operationArl.getName().equals(operationName) || !operationArl.getSignature().equals(signature)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public AttributeARL getAttributeARL(String attributeName) {
        for (AttributeARL atARL : CollectionUtil.nullSafe(this.attributesARL)) {
            if (!atARL.getName().equals(attributeName)) continue;
            return atARL;
        }
        return null;
    }

    public Set<PermissionARL> getAttributePermissionARLs(String attributeName, String role) {
        RoleARL roleARL = this.getAttributeRoleARL(attributeName, role);
        if (roleARL == null) {
            return null;
        }
        return roleARL.getPermissions();
    }

    public List<PermissionValue> getAttributePermissionValues() {
        return this.attributePermissionValues;
    }

    public RoleARL getAttributeRoleARL(String attributeName, String role) {
        AttributeARL atARL = this.getAttributeARL(attributeName);
        if (atARL != null) {
            for (RoleARL roleARL : CollectionUtil.nullSafe(atARL.getRoles())) {
                if (!roleARL.getName().equalsIgnoreCase(role)) continue;
                return roleARL;
            }
        }
        return null;
    }

    public List<AttributeARL> getAttributesARL() {
        return this.attributesARL;
    }

    public String getDefaultSecurityModule() {
        return this.defaultSecurityModule;
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    public OperationARL getOperationARL(String operationName, String signature) {
        for (OperationARL opARL : CollectionUtil.nullSafe(this.operationsARL)) {
            if (!opARL.getName().equals(operationName) || !opARL.getSignature().equals(signature)) continue;
            return opARL;
        }
        return null;
    }

    public Set<PermissionARL> getOperationPermissionARLs(String operationName, String signature, String role) {
        RoleARL roleARL = this.getOperationRoleARL(operationName, signature, role);
        if (roleARL == null) {
            return null;
        }
        return roleARL.getPermissions();
    }

    public List<PermissionValue> getOperationPermissionValues() {
        return this.operationPermissionValues;
    }

    public RoleARL getOperationRoleARL(String operationName, String signature, String role) {
        OperationARL opARL = this.getOperationARL(operationName, signature);
        if (opARL != null) {
            for (RoleARL roleARL : CollectionUtil.nullSafe(opARL.getRoles())) {
                if (!roleARL.getName().equalsIgnoreCase(role)) continue;
                return roleARL;
            }
        }
        return null;
    }

    public List<OperationARL> getOperationsARL() {
        return this.operationsARL;
    }

    public boolean hasAttributePermission(String attributeName, String role, String permission) {
        Set<PermissionARL> permissions = this.getAttributePermissionARLs(attributeName, role);
        if (permissions != null) {
            for (PermissionARL permARL : CollectionUtil.nullSafe(permissions)) {
                if (!permARL.getName().equalsIgnoreCase(permission)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOperationPermission(String operationName, String signature, String role, String permission) {
        Set<PermissionARL> permissions = this.getOperationPermissionARLs(operationName, signature, role);
        for (PermissionARL perm : CollectionUtil.nullSafe(permissions)) {
            if (!perm.getName().equalsIgnoreCase(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean isSecurityModSupportedByAttr(String attributeName, String secModule) {
        AttributeARL atARL = this.getAttributeARL(attributeName);
        if (atARL != null) {
            List<SecurityModule> secModules = atARL.getSecurityModules();
            for (SecurityModule mod : CollectionUtil.nullSafe(secModules)) {
                if (!mod.getName().equalsIgnoreCase(secModule)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSecurityModSupportedByOp(String operationName, String signature, String secModule) {
        OperationARL opARL = this.getOperationARL(operationName, signature);
        if (opARL != null) {
            List<SecurityModule> secModules = opARL.getSecurityModules();
            for (SecurityModule mod : CollectionUtil.nullSafe(secModules)) {
                if (!mod.getName().equalsIgnoreCase(secModule)) continue;
                return true;
            }
        }
        return false;
    }

    public void setAttributePermissions(String attributeName, String role, String[] permissions) {
        RoleARL roleARL;
        AttributeARL atARL = this.getAttributeARL(attributeName);
        if (atARL == null) {
            atARL = new AttributeARL();
            atARL.setName(attributeName);
            atARL.addSecurityModule(this.getDefaultSecurityModule());
            this.addAttributeARL(atARL);
        }
        if ((roleARL = this.getAttributeRoleARL(attributeName, role)) == null) {
            roleARL = new RoleARL();
            roleARL.setName(role);
            atARL.addRole(roleARL);
        } else {
            roleARL.clearPermissions();
        }
        ArrayList<PermissionARL> permissionARLs = new ArrayList<PermissionARL>(3);
        for (String permission : permissions) {
            PermissionARL permARL = new PermissionARL();
            permARL.setName(permission);
            permissionARLs.add(permARL);
        }
        roleARL.setPermissions(permissionARLs);
    }

    public void setAttributePermissionValues(List<PermissionValue> attributePermissionValues) {
        this.attributePermissionValues = attributePermissionValues;
    }

    public void setAttributesARL(List<AttributeARL> attributesARL) {
        this.attributesARL = attributesARL;
    }

    public void setAttributeSecurityModules(String attributeName, String[] secModules) {
        AttributeARL atARL = this.getAttributeARL(attributeName);
        if (atARL == null) {
            atARL = new AttributeARL();
            atARL.setName(attributeName);
            this.addAttributeARL(atARL);
        } else {
            atARL.clearSecurityModules();
        }
        for (String secModule : secModules) {
            atARL.addSecurityModule(secModule);
        }
    }

    public void setDefaultSecurityModule(String defaultSecurityModule) {
        this.defaultSecurityModule = defaultSecurityModule;
    }

    public void setMbeanName(String mbeanName) {
        this.mbeanName = mbeanName;
    }

    public void setOperationPermissions(String operationName, String signature, String role, String[] permissions) {
        RoleARL roleARL;
        OperationARL opARL = this.getOperationARL(operationName, signature);
        if (opARL == null) {
            opARL = new OperationARL();
            opARL.setName(operationName);
            opARL.setSignature(signature);
            opARL.addSecurityModule(this.getDefaultSecurityModule());
            this.addOperationARL(opARL);
        }
        if ((roleARL = this.getOperationRoleARL(operationName, signature, role)) == null) {
            roleARL = new RoleARL();
            roleARL.setName(role);
            opARL.addRole(roleARL);
        } else {
            roleARL.clearPermissions();
        }
        ArrayList<PermissionARL> permissionARLs = new ArrayList<PermissionARL>(2);
        for (String permission : CollectionUtil.nullSafe(permissions)) {
            PermissionARL permARL = new PermissionARL();
            permARL.setName(permission);
            permissionARLs.add(permARL);
        }
        roleARL.setPermissions(permissionARLs);
    }

    public void setOperationPermissionValues(List<PermissionValue> operationPermissionValues) {
        this.operationPermissionValues = operationPermissionValues;
    }

    public void setOperationsARL(List<OperationARL> operationsARL) {
        this.operationsARL = operationsARL;
    }

    public void setOperationSecurityModules(String operationName, String signature, String[] secModules) {
        OperationARL opARL = this.getOperationARL(operationName, signature);
        if (opARL == null) {
            opARL = new OperationARL();
            opARL.setName(operationName);
            opARL.setSignature(signature);
            this.addOperationARL(opARL);
        } else {
            opARL.clearSecurityModules();
        }
        for (String secModuleName : secModules) {
            opARL.addSecurityModule(secModuleName);
        }
    }

    public String toXML() throws IOException {
        Document doc = new Document();
        Element root = new Element(XML_ELEMENT_ROOT);
        doc.addContent((Content)root);
        Element mbean = new Element(XML_ELEMENT_MBEAN);
        mbean.setAttribute("name", this.getMbeanName());
        mbean.setAttribute(XML_ELEMENT_MBEAN_ATTRIBUTE_DEFAULT_SEC_MODULE, this.getDefaultSecurityModule());
        root.addContent((Content)mbean);
        Element attributes = new Element(XML_ELEMENT_ATTRIBUTES);
        root.addContent((Content)attributes);
        for (PermissionValue permValue : CollectionUtil.nullSafe(this.attributePermissionValues)) {
            Element permissionValue = new Element(XML_ELEMENT_PERMISSION_VALUE);
            attributes.addContent((Content)permissionValue);
            permissionValue.setAttribute("name", permValue.getName());
            permissionValue.setAttribute(XML_ELEMENT_PERMISSION_VALUE_ATTRIBUTE_ABBREVIATION, permValue.getAbbreviation());
            permissionValue.setAttribute(XML_ELEMENT_PERMISSION_VALUE_ATTRIBUTE_DESCRIPTION, permValue.getDescription());
        }
        for (AttributeARL attributeARL : CollectionUtil.nullSafe(this.attributesARL)) {
            Element attribute = new Element(XML_ELEMENT_ATTRIBUTE);
            attributes.addContent((Content)attribute);
            attribute.setAttribute("name", attributeARL.getName());
            Element modules = new Element(XML_ELEMENT_SECURITY_MODULES);
            attribute.addContent((Content)modules);
            for (SecurityModule secModule : CollectionUtil.nullSafe(attributeARL.getSecurityModules())) {
                Element module = new Element(XML_ELEMENT_MODULE);
                module.setAttribute("name", secModule.getName());
                modules.addContent((Content)module);
            }
            for (RoleARL roleARL : CollectionUtil.nullSafe(attributeARL.getRoles())) {
                Element role = new Element(XML_ELEMENT_ROLE);
                attribute.addContent((Content)role);
                role.setAttribute("name", roleARL.getName());
                for (PermissionARL permARL : CollectionUtil.nullSafe(roleARL.getPermissions())) {
                    Element permission = new Element(XML_ELEMENT_PERMISSION);
                    role.addContent((Content)permission);
                    permission.setAttribute("name", permARL.getName());
                }
            }
        }
        Element operations = new Element(XML_ELEMENT_OPERATIONS);
        root.addContent((Content)operations);
        for (PermissionValue permValue : CollectionUtil.nullSafe(this.operationPermissionValues)) {
            Element permissionValue = new Element(XML_ELEMENT_PERMISSION_VALUE);
            operations.addContent((Content)permissionValue);
            permissionValue.setAttribute("name", permValue.getName());
            permissionValue.setAttribute(XML_ELEMENT_PERMISSION_VALUE_ATTRIBUTE_ABBREVIATION, permValue.getAbbreviation());
            permissionValue.setAttribute(XML_ELEMENT_PERMISSION_VALUE_ATTRIBUTE_DESCRIPTION, permValue.getDescription());
        }
        for (OperationARL opARL : CollectionUtil.nullSafe(this.operationsARL)) {
            Element op = new Element(XML_ELEMENT_OPERATION);
            operations.addContent((Content)op);
            op.setAttribute("name", opARL.getName());
            String signature = opARL.getSignature();
            if (signature == null) {
                signature = "";
            }
            op.setAttribute(XML_ELEMENT_OPERATION_ATTRIBUTE_SIGNATURE, signature);
            Element modules = new Element(XML_ELEMENT_SECURITY_MODULES);
            op.addContent((Content)modules);
            for (SecurityModule secModule : CollectionUtil.nullSafe(opARL.getSecurityModules())) {
                Element module = new Element(XML_ELEMENT_MODULE);
                module.setAttribute("name", secModule.getName());
                modules.addContent((Content)module);
            }
            for (RoleARL roleARL : CollectionUtil.nullSafe(opARL.getRoles())) {
                Element role = new Element(XML_ELEMENT_ROLE);
                op.addContent((Content)role);
                role.setAttribute("name", roleARL.getName());
                for (PermissionARL permARL : CollectionUtil.nullSafe(roleARL.getPermissions())) {
                    Element permission = new Element(XML_ELEMENT_PERMISSION);
                    role.addContent((Content)permission);
                    permission.setAttribute("name", permARL.getName());
                }
            }
        }
        String xml = JDomUtil.toString(doc);
        return xml;
    }
}

