/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security.ac;

import com.sybase.ua.security.ac.PermissionARL;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RoleARL
implements Serializable,
Comparable<RoleARL> {
    static final long serialVersionUID = -5808472079011251964L;
    static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", String.class), new ObjectStreamField("permissions", List.class)};
    private String name;
    private Set<PermissionARL> permissions = new HashSet<PermissionARL>(5);

    public static Comparator<RoleARL> getNameComparator() {
        return new Comparator<RoleARL>(){

            @Override
            public int compare(RoleARL o1, RoleARL o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }

    public RoleARL() {
    }

    public RoleARL(String name, Collection<PermissionARL> permissions) {
        this.setName(name);
        this.setPermissions(permissions);
    }

    public RoleARL(String name, PermissionARL ... permissions) {
        this.setName(name);
        this.setPermissions(Arrays.asList(permissions));
    }

    public void addPermission(PermissionARL permARL) {
        if (!this.permissions.contains(permARL)) {
            this.permissions.add(permARL);
        }
    }

    public void clearPermissions() {
        this.permissions.clear();
    }

    @Override
    public int compareTo(RoleARL o) {
        int diff = 0;
        diff = this.name.compareTo(o.getName());
        if (diff != 0) {
            return diff;
        }
        diff = this.permissions.size() - o.getPermissions().size();
        if (diff != 0) {
            return diff;
        }
        Iterator<PermissionARL> cmpPerms = o.getPermissions().iterator();
        for (PermissionARL perm : this.permissions) {
            if ((diff += perm.toString().compareTo(cmpPerms.next().toString())) == 0) continue;
            return diff;
        }
        return diff;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoleARL other = (RoleARL)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.permissions == null ? other.permissions != null : !((Object)this.permissions).equals(other.permissions));
    }

    public String getName() {
        return this.name;
    }

    public Set<PermissionARL> getPermissions() {
        return this.permissions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.permissions == null ? 0 : ((Object)this.permissions).hashCode());
        return result;
    }

    public boolean hasPermission(String permission) {
        for (PermissionARL perm : this.getPermissions()) {
            if (!perm.getName().equalsIgnoreCase(permission)) continue;
            return true;
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPermissions(Collection<PermissionARL> permissions) {
        this.permissions.addAll(permissions);
    }

    public String toString() {
        return this.name + ":" + this.permissions;
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        try {
            ObjectInputStream.GetField gf = ois.readFields();
            this.name = (String)gf.get("name", null);
            Object permissionsObject = gf.get("permissions", null);
            if (permissionsObject instanceof Set) {
                this.permissions = (Set)permissionsObject;
            } else {
                this.permissions = new HashSet<PermissionARL>();
                this.permissions.addAll((List)permissionsObject);
            }
            if (this.name == null || this.permissions == null) {
                throw new InvalidClassException("Error deserializing RoleARL");
            }
            return;
        }
        catch (Exception e) {
            throw new InvalidClassException("Error deserializing RoleARL: " + e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        try {
            ObjectOutputStream.PutField pf = oos.putFields();
            pf.put("name", this.name);
            ArrayList<PermissionARL> permissionsAsList = new ArrayList<PermissionARL>();
            permissionsAsList.addAll(this.permissions);
            pf.put("permissions", permissionsAsList);
            oos.writeFields();
        }
        catch (Exception e) {
            throw new InvalidClassException("Error serializing RoleARL: " + e.getMessage());
        }
    }
}

