/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security.ac;

import com.sybase.ua.security.ac.RoleARL;
import com.sybase.ua.security.ac.SecurityModule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RoleBasedARL
implements Serializable {
    private static final long serialVersionUID = -3478158469345636997L;
    private String name;
    private List<SecurityModule> securityModules = new ArrayList<SecurityModule>(3);
    private List<RoleARL> roles = new ArrayList<RoleARL>(5);

    public RoleBasedARL() {
    }

    public RoleBasedARL(RoleBasedARL copy) {
        this.name = copy.getName();
        this.securityModules.addAll(copy.getSecurityModules());
        this.roles.addAll(copy.getRoles());
    }

    RoleBasedARL(String name, List<SecurityModule> securityModules, List<RoleARL> roles) {
        this.name = name;
        this.securityModules = securityModules;
        this.roles = roles;
    }

    public void addRole(RoleARL roleARL) {
        this.roles.add(roleARL);
    }

    public void addSecurityModule(SecurityModule securityModule) {
        this.securityModules.add(securityModule);
    }

    public void addSecurityModule(String moduleName) {
        SecurityModule secModule = new SecurityModule();
        secModule.setName(moduleName);
        this.securityModules.add(secModule);
    }

    public void clearSecurityModules() {
        this.securityModules.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoleBasedARL other = (RoleBasedARL)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !((Object)this.roles).equals(other.roles)) {
            return false;
        }
        return !(this.securityModules == null ? other.securityModules != null : !((Object)this.securityModules).equals(other.securityModules));
    }

    public String getName() {
        return this.name;
    }

    public List<RoleARL> getRoles() {
        return this.roles;
    }

    public List<SecurityModule> getSecurityModules() {
        return this.securityModules;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.roles == null ? 0 : ((Object)this.roles).hashCode());
        result = 31 * result + (this.securityModules == null ? 0 : ((Object)this.securityModules).hashCode());
        return result;
    }

    public void setName(String name) {
        this.name = name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public void setRoles(List<RoleARL> roles) {
        this.roles = roles;
    }

    public void setSecurityModules(List<SecurityModule> securityModules) {
        this.securityModules = securityModules;
    }

    public String toString() {
        return this.name + ":" + this.roles + ":" + this.securityModules;
    }
}

