/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security.ac;

import com.sybase.ua.security.ac.Role;
import com.sybase.ua.security.ac.RoleMapping;
import com.sybase.ua.security.ac.SecurityModule;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class RolesMap
implements Serializable {
    static final long serialVersionUID = 4200715613417514089L;
    private List<Role> uafRoles = new ArrayList<Role>(8);
    private List<SecurityModule> securityModules = new ArrayList<SecurityModule>(3);
    public static final String XML_ELEMENT_ROOT = "roles-map";
    public static final String XML_ELEMENT_UAFROLES = "uaf-roles";
    public static final String XML_ELEMENT_ROLE = "role";
    public static final String XML_ELEMENT_ROLE_ATTRIBUTE_NAME = "name";
    public static final String XML_ELEMENT_ROLE_ATTRIBUTE_DESCRIPTION = "description";
    public static final String XML_ELEMENT_SECURITY_MODULES = "security-modules";
    public static final String XML_ELEMENT_MODULE = "module";
    public static final String XML_ELEMENT_MODULE_NAME = "name";
    public static final String XML_ELEMENT_ROLEMAPPING = "role-mapping";
    public static final String XML_ELEMENT_ROLEMAPPING_ATTRIBUTE_MODULEROLE = "modRole";
    public static final String XML_ELEMENT_ROLEMAPPING_ATTRIBUTE_UAFROLE = "uafRole";

    public void addRoleMapping(String securityModule, String modRole, String uafRole) {
        for (int i = 0; i < this.securityModules.size(); ++i) {
            SecurityModule module = this.securityModules.get(i);
            if (!module.getName().equalsIgnoreCase(securityModule)) continue;
            RoleMapping mapping = new RoleMapping(modRole, uafRole);
            module.addRoleMapping(mapping);
        }
    }

    public void addSecurityModule(SecurityModule module) {
        this.securityModules.add(module);
    }

    public void addUAFRole(Role role) {
        this.uafRoles.add(role);
    }

    public List<RoleMapping> getRoleMappings(String securityModuleName) {
        for (SecurityModule sm : this.securityModules) {
            if (!sm.getName().equals(securityModuleName)) continue;
            return sm.getRoleMappings();
        }
        return Collections.EMPTY_LIST;
    }

    public List<SecurityModule> getSecurityModules() {
        return this.securityModules;
    }

    public List<Role> getUafRoles() {
        return this.uafRoles;
    }

    public void removeRoleMapping(String securityModule, String modRole, String uafRole) {
        for (int i = 0; i < this.securityModules.size(); ++i) {
            SecurityModule module = this.securityModules.get(i);
            if (!module.getName().equalsIgnoreCase(securityModule)) continue;
            RoleMapping mapping = new RoleMapping(modRole, uafRole);
            module.removeRoleMapping(mapping);
        }
    }

    public void removeSecurityModule(String securityModule) {
        for (int i = 0; i < this.securityModules.size(); ++i) {
            SecurityModule module = this.securityModules.get(i);
            if (!module.getName().equalsIgnoreCase(securityModule)) continue;
            this.securityModules.remove(i);
            break;
        }
    }

    public void setSecurityModules(List<SecurityModule> securityModules) {
        this.securityModules = securityModules;
    }

    public void setUafRoles(List<Role> uafRoles) {
        this.uafRoles = uafRoles;
    }

    public String toXML() throws IOException {
        Document doc = new Document();
        Element root = new Element(XML_ELEMENT_ROOT);
        doc.addContent((Content)root);
        Element uafRolesEle = new Element(XML_ELEMENT_UAFROLES);
        root.addContent((Content)uafRolesEle);
        for (Role role : this.uafRoles) {
            Element roleEle = new Element(XML_ELEMENT_ROLE);
            uafRolesEle.addContent((Content)roleEle);
            roleEle.setAttribute("name", role.getName());
            roleEle.setAttribute(XML_ELEMENT_ROLE_ATTRIBUTE_DESCRIPTION, role.getDescription());
        }
        Element secModulesEle = new Element(XML_ELEMENT_SECURITY_MODULES);
        root.addContent((Content)secModulesEle);
        for (SecurityModule module : this.securityModules) {
            Element moduleEle = new Element(XML_ELEMENT_MODULE);
            secModulesEle.addContent((Content)moduleEle);
            moduleEle.setAttribute("name", module.getName());
            Iterator<RoleMapping> i$ = module.getRoleMappings().iterator();
            while (i$.hasNext()) {
                RoleMapping name;
                RoleMapping roleMapping = name = i$.next();
                Element roleMappingEle = new Element(XML_ELEMENT_ROLEMAPPING);
                moduleEle.addContent((Content)roleMappingEle);
                roleMappingEle.setAttribute(XML_ELEMENT_ROLEMAPPING_ATTRIBUTE_MODULEROLE, roleMapping.getModuleRole());
                roleMappingEle.setAttribute(XML_ELEMENT_ROLEMAPPING_ATTRIBUTE_UAFROLE, roleMapping.getUafRole());
            }
        }
        String xml = JDomUtil.toString(doc);
        return xml;
    }
}

