/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security.annotation;

import com.sybase.ua.security.annotation.Access;
import com.sybase.ua.security.annotation.AnnotationUtil;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class AccessAnnotationInfo<T extends Member & AnnotatedElement> {
    private final T _member;
    private final List<Access> _accessAnnotations;

    public static <T extends Member & AnnotatedElement> AccessAnnotationInfo<T> getAccessAnnotationInfo(T member) {
        List<Access> a = AnnotationUtil.getAccessAnnotations(member);
        if (a == null || a.isEmpty()) {
            return null;
        }
        return new AccessAnnotationInfo<T>(member, a);
    }

    AccessAnnotationInfo(T member, List<Access> accessAnnotations) {
        this._member = member;
        this._accessAnnotations = accessAnnotations == null ? new LinkedList() : accessAnnotations;
    }

    public List<Access> getAccessAnnotations() {
        return this._accessAnnotations;
    }

    public Class<?> getDeclaringClass() {
        return this._member.getDeclaringClass();
    }

    public T getMember() {
        return this._member;
    }

    public ElementType getMemberType() {
        if (this._member.getClass().isInstance(Field.class)) {
            return ElementType.FIELD;
        }
        if (this._member.getClass().isInstance(Method.class)) {
            return ElementType.METHOD;
        }
        if (this._member.getClass().isInstance(Constructor.class)) {
            return ElementType.CONSTRUCTOR;
        }
        if (this._member.getClass().isInstance(Class.class)) {
            return ElementType.TYPE;
        }
        throw new IllegalStateException("Member is not a supported type: " + this._member.getClass().getName());
    }

    public String toString() {
        return this.getDeclaringClass().getSimpleName() + "#" + this._member.getName() + ":" + this._accessAnnotations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._accessAnnotations == null ? 0 : ((Object)this._accessAnnotations).hashCode());
        result = 31 * result + (this._member == null ? 0 : this._member.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessAnnotationInfo other = (AccessAnnotationInfo)obj;
        if (this._accessAnnotations == null ? other._accessAnnotations != null : !((Object)this._accessAnnotations).equals(other._accessAnnotations)) {
            return false;
        }
        return !(this._member == null ? other._member != null : !this._member.equals(other._member));
    }
}

