/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security.annotation;

import com.sybase.ua.security.ac.PermissionARL;
import com.sybase.ua.security.ac.RoleARL;
import com.sybase.ua.security.annotation.Access;
import com.sybase.ua.security.annotation.AccessAnnotationInfo;
import com.sybase.ua.security.annotation.AccessType;
import com.sybase.ua.security.annotation.Security;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AnnotationUtil {
    public static boolean containsRole(Collection<RoleARL> existingRoles, RoleARL role) {
        Comparator<RoleARL> roleNameComparator = RoleARL.getNameComparator();
        for (RoleARL existing : existingRoles) {
            if (roleNameComparator.compare(existing, role) != 0) continue;
            return true;
        }
        return false;
    }

    public static Set<AccessAnnotationInfo<Method>> findAccessAnnotatedMethodsInHierarchy(Method m) {
        return AnnotationUtil.findAccessAnnotatedMethodsInHierarchy(m.getDeclaringClass(), m.getName(), m.getParameterTypes());
    }

    public static Set<AccessAnnotationInfo<Method>> findAccessAnnotatedMethodsInHierarchy(Class<?> c, String name, Class<?> ... paramTypes) {
        if (c == null) {
            return null;
        }
        LinkedHashSet<AccessAnnotationInfo<Method>> methodDeclarations = new LinkedHashSet<AccessAnnotationInfo<Method>>();
        AnnotationUtil.addMethodAccessAnnotations(c, name, paramTypes, methodDeclarations);
        AnnotationUtil.processInterfaceAnnotations(c, name, paramTypes, methodDeclarations);
        for (Class<?> sc = c.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            AnnotationUtil.addMethodAccessAnnotations(sc, name, paramTypes, methodDeclarations);
            AnnotationUtil.processInterfaceAnnotations(sc, name, paramTypes, methodDeclarations);
        }
        return methodDeclarations;
    }

    private static void processInterfaceAnnotations(Class<?> ic, String name, Class<?>[] paramTypes, Set<AccessAnnotationInfo<Method>> methodDeclarations) {
        Class<?>[] pics;
        AnnotationUtil.addMethodAccessAnnotations(ic, name, paramTypes, methodDeclarations);
        for (Class<?> pic : pics = ic.getInterfaces()) {
            AnnotationUtil.processInterfaceAnnotations(pic, name, paramTypes, methodDeclarations);
        }
    }

    private static void addMethodAccessAnnotations(Class<?> ic, String name, Class<?>[] paramTypes, Set<AccessAnnotationInfo<Method>> methodDeclarations) {
        List<Access> aa;
        Method m = AnnotationUtil.getDeclaredMethod(ic, name, paramTypes);
        if (m != null && (aa = AnnotationUtil.getAccessAnnotations(m)) != null && !aa.isEmpty()) {
            AccessAnnotationInfo<Method> ai = new AccessAnnotationInfo<Method>(m, aa);
            methodDeclarations.add(ai);
        }
    }

    public static Field findFieldInHierarchy(Class<?> c, String name) {
        if (c == null) {
            return null;
        }
        Field f = null;
        f = AnnotationUtil.getDeclaredField(c, name);
        if (f != null) {
            return f;
        }
        return AnnotationUtil.findFieldInHierarchy(c.getSuperclass(), name);
    }

    public static List<Access> getAccessAnnotations(AnnotatedElement el) {
        ArrayList<Access> accessAnnotations = new ArrayList<Access>();
        if (el == null || !el.isAnnotationPresent(Security.class) && !el.isAnnotationPresent(Access.class)) {
            return accessAnnotations;
        }
        for (Annotation a : el.getAnnotations()) {
            if (a.annotationType().isAssignableFrom(Security.class)) {
                Security s = (Security)a;
                accessAnnotations.addAll(Arrays.asList(s.value()));
            }
            if (!a.annotationType().isAssignableFrom(Access.class)) continue;
            Access ac = (Access)a;
            accessAnnotations.add(ac);
        }
        return accessAnnotations;
    }

    public static Field getDeclaredField(Class<?> c, String name) {
        try {
            return c.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> c, String name, Class<?> ... types) {
        try {
            return c.getDeclaredMethod(name, types);
        }
        catch (NoSuchMethodException nsfe) {
            return null;
        }
    }

    public static Method getMethod(Class<?> c, String name, Class<?> ... types) {
        try {
            return c.getMethod(name, types);
        }
        catch (NoSuchMethodException nsfe) {
            return null;
        }
    }

    public static Collection<RoleARL> getFieldRolesFromHierarchy(Class<?> c, String name) {
        return AnnotationUtil.getRoles(AnnotationUtil.findFieldInHierarchy(c, name));
    }

    public static SortedSet<RoleARL> getMethodRolesFromHierarchy(Class<?> c, String name, Class<?> ... parameterTypes) {
        Set<AccessAnnotationInfo<Method>> ah = AnnotationUtil.findAccessAnnotatedMethodsInHierarchy(c, name, parameterTypes);
        TreeSet<RoleARL> rs = new TreeSet<RoleARL>(RoleARL.getNameComparator());
        for (AccessAnnotationInfo<Method> aaim : ah) {
            List<RoleARL> all = AnnotationUtil.getRoles(aaim.getAccessAnnotations());
            for (RoleARL r : all) {
                if (AnnotationUtil.containsRole(rs, r)) continue;
                rs.add(r);
            }
        }
        return rs;
    }

    public static List<RoleARL> getRoles(AnnotatedElement el) {
        List<Access> accessAnnotations = AnnotationUtil.getAccessAnnotations(el);
        return AnnotationUtil.getRoles(accessAnnotations);
    }

    public static Set<String> getRoles(AnnotatedElement el, AccessType accessType) {
        HashSet<String> rolesWithAccess = new HashSet<String>();
        List<Access> accessAnnotations = AnnotationUtil.getAccessAnnotations(el);
        for (Access a : accessAnnotations) {
            List<AccessType> accessTypes = Arrays.asList(a.access());
            if (!accessTypes.contains((Object)accessType)) continue;
            rolesWithAccess.addAll(Arrays.asList(a.role()));
        }
        return rolesWithAccess;
    }

    public static List<RoleARL> getRoles(List<Access> accessAnnotations) {
        LinkedList<RoleARL> roles = new LinkedList<RoleARL>();
        if (accessAnnotations == null) {
            return roles;
        }
        for (Access a : accessAnnotations) {
            for (String role : a.role()) {
                String[] possiblyCombinedRoles;
                for (String r : possiblyCombinedRoles = role.split(",")) {
                    RoleARL ra = new RoleARL();
                    ra.setName(r.trim());
                    for (AccessType at : a.access()) {
                        PermissionARL pa = new PermissionARL();
                        pa.setName(at.name());
                        ra.addPermission(pa);
                    }
                    roles.add(ra);
                }
            }
        }
        return roles;
    }

    public static <T extends Member & AnnotatedElement> List<RoleARL> getRolesFromHierarchy(T el) {
        LinkedList<RoleARL> roles = new LinkedList<RoleARL>();
        if (el instanceof Field) {
            Field f = (Field)el;
            roles.addAll(AnnotationUtil.getFieldRolesFromHierarchy(f.getDeclaringClass(), f.getName()));
        } else if (el instanceof Method) {
            Method m = (Method)el;
            SortedSet<RoleARL> rs = AnnotationUtil.getMethodRolesFromHierarchy(m.getDeclaringClass(), m.getName(), m.getParameterTypes());
            roles.addAll(rs);
        } else if (el.getClass().isInstance(Constructor.class) || el.getClass().isInstance(Class.class)) {
            // empty if block
        }
        return roles;
    }

    public static boolean hasAccess(AnnotatedElement el, String role, AccessType accessType) {
        List<Access> accessAnnotations = AnnotationUtil.getAccessAnnotations(el);
        for (Access a : accessAnnotations) {
            List<AccessType> accessTypes;
            List<String> roles = Arrays.asList(a.role());
            if (!roles.contains(role) || !(accessTypes = Arrays.asList(a.access())).contains((Object)accessType)) continue;
            return true;
        }
        return false;
    }
}

