/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.security.crypto;

import com.sybase.ua.services.security.tool.CipherTool;
import com.sybase.ua.services.security.tool.EncryptionKeyManager;
import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;

public class SecureObject
implements Serializable {
    static final long serialVersionUID = -1462491276249859737L;
    public static final String DEFAULT_ENCRYPTION_ALGORITHM = "DES";
    public static final String DEFAULT_PROVIDER_CLASS = "com.sun.crypto.provider.SunJCE";
    private final SealedObject sealedObject;
    private String encryptionAlgorithm = "DES";
    private String cipherProviderClass = "com.sun.crypto.provider.SunJCE";

    public SecureObject(Serializable object) throws Exception {
        this(object, DEFAULT_ENCRYPTION_ALGORITHM, DEFAULT_PROVIDER_CLASS);
    }

    public SecureObject(Serializable object, String encryptionAlgorithm, String cipherProviderClass) throws Exception {
        this.setEncryptionAlgorithm(encryptionAlgorithm);
        this.setCipherProviderClass(cipherProviderClass);
        Key encryptionKey = EncryptionKeyManager.getInstance().getEncryptionKeyByID(encryptionAlgorithm + ".SECURE.OBJECT", cipherProviderClass);
        CipherTool cipherTool = new CipherTool(this.getEncryptionAlgorithm(), this.getCipherProviderClass(), encryptionKey);
        cipherTool.init();
        Cipher cipher = cipherTool.getCipher();
        cipher.init(1, encryptionKey);
        this.sealedObject = new SealedObject(object, cipher);
    }

    public String getCipherProviderClass() {
        return this.cipherProviderClass;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public SealedObject getSealedObject() {
        return this.sealedObject;
    }

    private void setCipherProviderClass(String cipherProviderClass) {
        this.cipherProviderClass = cipherProviderClass;
    }

    private void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }
}

