/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.service;

import com.sybase.ua.config.AdaptorConfig;
import com.sybase.ua.config.DependencyConfig;
import com.sybase.ua.config.LoggerConfig;
import com.sybase.ua.security.ac.ARL;
import com.sybase.ua.security.annotation.Access;
import com.sybase.ua.security.annotation.AccessType;
import com.sybase.ua.security.annotation.Security;
import com.sybase.ua.service.AgentServiceException;
import com.sybase.ua.services.extservice.ServiceAutoUnregisterThread;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public interface AgentServiceMBean {
    public static final String DOMAIN = "AgentService";
    public static final String PRIMORDIAL_SERVICE_BASE_DIR = "services";
    public static final String EXTENDED_SERVICE_BASE_DIR = "services";
    public static final String SERVICE_CONFIG_XML = "service-config.xml";
    public static final String SERVICE_CONFIG_DTD = "service-config.dtd";
    public static final String SERVICE_CONFIG_DTD_PUBLIC_ID = "-//Sybase Unified Agent Framework Service Configuration//DTD service-config 2.0.0//EN";
    public static final String DEFAULT_ARL_CONFIG = "arl.xml";
    public static final String DEFAULT_MBEAN_DESCRIPTOR = "mbean-descriptor.xml";
    public static final String TYPE_STANDARD_MBEAN = "Standard MBean";
    public static final String TYPE_MODEL_MBEAN = "Model MBean";
    public static final String METHOD_START = "start";
    public static final String METHOD_RESTART = "restart";
    public static final String METHOD_STOP = "stop";
    public static final String PROPERTY_STARTED = "started";
    public static final String DEFAULT_VERSION = "1.5.0";
    public static final String DEFAULT_PROVIDER_NAME = "Sybase, Inc.";
    public static final String XML_ELEMENT_ROOT = "service-config";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_VERSION = "version";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_ID = "id";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_NAME = "name";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_CLASS = "class";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_PROVIDER_NAME = "provider-name";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_REGISTER_ON_STARTUP = "register-on-startup";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_MBEAN_TYPE = "mbean-type";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_MBEAN_DESCRIPTOR = "mbean-descriptor";
    public static final String XML_ELEMENT_ROOT_ATTRIBUTE_ARL_CONFIG = "arl-config";
    public static final String XML_ELEMENT_DEPENDENCIES = "dependencies";
    public static final String XML_ELEMENT_DEPENDENCY = "dependency";
    public static final String XML_ELEMENT_DEPENDENCY_ATTRIBUTE_TYPE = "type";
    public static final String XML_ELEMENT_DEPENDENCY_ATTRIBUTE_ID = "id";
    public static final String XML_ELEMENT_DEPENDENCY_ATTRIBUTE_VERSION = "version";
    public static final String XML_ELEMENT_DEPENDENCY_ATTRIBUTE_AUTO_UNREGISTER_WHEN_NOT_REFERENCED = "auto-unregister-when-not-referenced";
    public static final String XML_ELEMENT_DEPENDENCY_ATTRIBUTE_AUTO_UNREGISTER_GRACE_PERIOD = "auto-unregister-grace-period";
    public static final String XML_ELEMENT_PROPERTIES = "properties";
    public static final String XML_ELEMENT_SET_PROPERTY = "set-property";
    public static final String XML_SET_PROPERTY_ATTRIBUTE_PROPERTY = "property";
    public static final String XML_SET_PROPERTY_ATTRIBUTE_VALUE = "value";
    public static final String XML_ELEMENT_ADAPTOR = "adaptor";
    public static final String XML_ELEMENT_ADAPTOR_ATTRIBUTE_CLASS = "class";
    public static final String XML_ELEMENT_ADAPTOR_ATTRIBUTE_ID = "id";
    public static final String XML_SET_PROPERTY_ATTRIBUTE_TYPE = "type";
    public static final String XML_ELEMENT_LOGGERS = "loggers";
    public static final String XML_ELEMENT_LOGGER = "logger";
    public static final String XML_ELEMENT_LOGGER_ATTRIBTUTE_NAME = "name";
    public static final String XML_ELEMENT_LOGGER_ATTRIBTUTE_LEVEL = "level";
    public static final String XML_ELEMENT_LOGGER_ATTRIBTUTE_ADDITVITY = "additivity";
    public static final String XML_ELEMENT_APPENDER = "appender";
    public static final String XML_ELEMENT_APPENDER_ATTRIBUTE_CLASS = "class";
    public static final String XML_ELEMENT_ARCHIVES = "archives";
    public static final String XML_ELEMENT_ARCHIVE = "archive";
    public static final String XML_ELEMENT_ARCHIVE_ATTRIBUTE_PATH = "path";

    public void addAutoUnregisterThread(ServiceAutoUnregisterThread var1);

    @Access(role={"uaAgentAdmin", "uaOSAdmin"})
    public void addFileAppender(String var1, String var2) throws Exception;

    @Access(role={"uaAgentAdmin", "uaOSAdmin"})
    public void addLogger(String var1, String var2) throws Exception;

    public void decrementReferenceCount();

    public List<AdaptorConfig> getAdaptorConfigs();

    @Access(role={"uaAgentAdmin"}, access={AccessType.READ})
    public ARL getArl();

    @Access(role={"uaAgentAdmin"}, access={AccessType.READ})
    public String getArlAsXML() throws AgentServiceException;

    @Access(role={"uaAgentAdmin"}, access={AccessType.READ, AccessType.WRITE})
    public String getArlConfig();

    public List<ServiceAutoUnregisterThread> getAutoUnregisterThreadList();

    @Access(role={"uaAgentAdmin"}, access={AccessType.READ})
    public String getBuildNumber();

    public String getConfigAsXML() throws IOException;

    @Security(value={@Access(role={"uaAgentAdmin"}, access={AccessType.READ, AccessType.WRITE}), @Access(role={"uaASEAdmin", "uaPluginAdmin", "uaAnonymous"}, access={AccessType.READ})})
    public List<DependencyConfig> getDependencies();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public String getId();

    @Access(role={"uaAgentAdmin", "uaOSAdmin"}, access={AccessType.READ, AccessType.WRITE})
    public LoggerConfig getLogger(String var1);

    @Access(role={"uaAgentAdmin", "uaOSAdmin"}, access={AccessType.READ, AccessType.WRITE})
    public LoggerConfig[] getLoggersAsArray();

    public String getMbeanDescriptor();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public String getMBeanName();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public String getMbeanType();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public String getName();

    @Deprecated
    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public ObjectName getObjectName() throws MalformedObjectNameException;

    public Map<String, Object> getPersistentProperties();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public Map<String, Object> getProperties();

    public String getProperty(String var1);

    @Security(value={@Access(role={"uaAgentAdmin"}, access={AccessType.READ, AccessType.WRITE}), @Access(role={"uaAnonymous"}, access={AccessType.READ})})
    public String getProviderName();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public int getReferenceCount();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public List<DependencyConfig> getReferenceList();

    public ClassLoader getServiceClassLoader();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public String getServiceHome();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public String getVersion();

    public void incrementReferenceCount();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public boolean isInited();

    @Security(value={@Access(role={"uaAgentAdmin"}, access={AccessType.READ, AccessType.WRITE}), @Access(role={"uaAnonymous"}, access={AccessType.READ})})
    public boolean isRegisterOnStartup();

    @Access(role={"uaAnonymous"}, access={AccessType.READ})
    public boolean isStarted();

    public void removeAutoUnregisterThread(ServiceAutoUnregisterThread var1);

    @Access(role={"uaAgentAdmin", "uaOSAdmin"})
    public void removeLogger(String var1) throws Exception;

    @Access(role={"uaAgentAdmin"}, access={AccessType.EXECUTE})
    public void restart() throws AgentServiceException;

    @Access(role={"uaAgentAdmin"}, access={AccessType.EXECUTE})
    public void saveArl(ARL var1) throws AgentServiceException;

    public void setAdaptorConfigs(List<AdaptorConfig> var1);

    public void setArl(ARL var1);

    public void setArlConfig(String var1);

    public void setBuildNumber(String var1);

    public void setDependencies(List<DependencyConfig> var1);

    public void setName(String var1);

    public void setProperties(Map<String, Object> var1);

    public void setProperty(String var1, String var2);

    public void setProviderName(String var1);

    public void setReferenceCount(int var1);

    public void setRegisterOnStartup(boolean var1);

    @Access(role={"uaAgentAdmin"}, access={AccessType.EXECUTE})
    public void start() throws AgentServiceException;

    @Access(role={"uaAgentAdmin"}, access={AccessType.EXECUTE})
    public void stop() throws AgentServiceException;
}

