/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.service;

import com.sybase.ua.loader.ServiceClassLoader;
import com.sybase.ua.service.AgentServiceException;
import com.sybase.ua.service.AgentServiceMBean;
import com.sybase.ua.service.ServiceMetaInfo;
import com.sybase.ua.services.Agent;
import java.io.File;
import java.util.ArrayList;

public class PrimordialServices
extends ArrayList<ServiceMetaInfo> {
    private static final long serialVersionUID = 1585772983914534697L;
    public static final String DIR_BOOTSTRAP_SERVICE = "Bootstrap";
    public static final String DIR_AGENT_SERVICE = "Agent";
    public static final String DIR_ENVIRONMENT_SERVICE = "Env";
    public static final String DIR_CONFIGURATION_SERVICE = "Config";
    public static final String DIR_SESSION_SERVICE = "Session";
    public static final String DIR_SECURITY_SERVICE = "Security";
    public static final String DIR_EXTENDED_SERVICE = "ExtService";
    public static final String[] primordialServiceDirs = new String[]{"Bootstrap", "Agent", "Env", "Config", "Session", "Security", "ExtService"};

    public PrimordialServices() {
        Agent agent = Agent.getInstance();
        String agentHome = agent.getAgentHome();
        for (String primordialServiceDir : primordialServiceDirs) {
            File serviceBaseDir = new File(agentHome, "services");
            File serviceDir = new File(serviceBaseDir, primordialServiceDir);
            try {
                ServiceMetaInfo serviceMetaInfo = new ServiceMetaInfo(serviceDir, this.getClass().getClassLoader());
                this.add(serviceMetaInfo);
            }
            catch (AgentServiceException e) {
                throw new IllegalStateException("Failed to load metadata for primordial services", e);
            }
        }
        Agent.getInstance().getAgentServices().setPrimordialServiceDefinitions(this);
        this.buildClassLoaderDependencies();
    }

    public boolean isPrimordialService(AgentServiceMBean serviceMBean) {
        String serviceId = serviceMBean.getId();
        return this.isPrimordialService(serviceId);
    }

    public boolean isPrimordialService(String serviceId) {
        boolean result = false;
        for (ServiceMetaInfo serviceMetaInfo : this) {
            if (!serviceId.equals(serviceMetaInfo.getServiceConfig().getId())) continue;
            result = true;
            break;
        }
        return result;
    }

    private void buildClassLoaderDependencies() {
        for (int i = 1; i < this.size(); ++i) {
            ServiceMetaInfo serviceMetaInfo = (ServiceMetaInfo)this.get(i);
            ClassLoader classloader = serviceMetaInfo.getServiceClassLoader();
            if (!(classloader instanceof ServiceClassLoader)) continue;
            ServiceMetaInfo serviceMetaInfo2 = (ServiceMetaInfo)this.get(i - 1);
            ClassLoader classloader2 = serviceMetaInfo2.getServiceClassLoader();
            ((ServiceClassLoader)classloader).addPrimordialServiceClassLoader(classloader2);
        }
    }
}

