/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.service;

import com.sybase.ua.config.AgentServiceConfig;
import com.sybase.ua.config.AgentServiceConfigRuleSet;
import com.sybase.ua.loader.ClassLoaderFactory;
import com.sybase.ua.loader.ServiceClassLoader;
import com.sybase.ua.service.AgentServiceException;
import com.sybase.ua.services.Agent;
import com.sybase.ua.util.DigesterUtil;
import java.io.File;
import org.apache.commons.digester.Digester;

public class ServiceMetaInfo {
    private final File serviceDirectory;
    private transient ClassLoader serviceClassLoader;
    private AgentServiceConfig serviceConfig;
    public static final String DEFAULT_MBEAN_DESCRIPTOR_XML = "mbean-descriptor.xml";

    public ServiceMetaInfo(File serviceDirectory) throws AgentServiceException {
        this.serviceDirectory = serviceDirectory;
        this.validateDirectoryStructure();
        this.createClassLoader();
        this.loadServiceConfig();
        this.validateDirectoryStructure2();
        this.setClassLoaderInfo();
    }

    public ServiceMetaInfo(File serviceDirectory, ClassLoader parentClassLoader) throws AgentServiceException {
        this.serviceDirectory = serviceDirectory;
        this.validateDirectoryStructure();
        this.serviceClassLoader = parentClassLoader;
        this.loadServiceConfig();
        this.validateDirectoryStructure2();
        this.setClassLoaderInfo();
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public AgentServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public File getServiceDirectory() {
        return this.serviceDirectory;
    }

    public void reloadServiceConfig() {
        this.loadServiceConfig();
    }

    public String toString() {
        return this.serviceConfig.getId() + "_" + this.serviceConfig.getVersion();
    }

    private void createClassLoader() throws AgentServiceException {
        try {
            this.serviceClassLoader = ClassLoaderFactory.createServiceClassLoader(this.serviceDirectory.getAbsolutePath(), Agent.getInstance().getServerClassLoader());
        }
        catch (Exception e) {
            throw new AgentServiceException("Failed to create ServiceClassLoader.", e);
        }
    }

    private void loadServiceConfig() throws AgentServiceException {
        File configXML = new File(this.serviceDirectory, "service-config.xml");
        File configDTD = new File(this.serviceDirectory, "service-config.dtd");
        Digester configDigester = null;
        try {
            configDigester = DigesterUtil.initDigester(configDTD, "-//Sybase Unified Agent Framework Service Configuration//DTD service-config 2.0.0//EN", new AgentServiceConfigRuleSet(), this.getServiceClassLoader());
        }
        catch (Exception e) {
            throw new AgentServiceException("Failed to init digester: " + configDTD.getAbsolutePath(), e);
        }
        try {
            this.serviceConfig = (AgentServiceConfig)DigesterUtil.parse(configDigester, configXML);
        }
        catch (Throwable t) {
            String msg = "Failed to parse XML: " + configXML.getAbsolutePath() + ". The file is probably corrupted. Please restore it from the backup.";
            throw new AgentServiceException(msg, t);
        }
        finally {
            configDigester.clear();
        }
        String serviceDirName = this.serviceDirectory.getName();
        this.serviceConfig.setServiceDirectory(serviceDirName);
    }

    private void setClassLoaderInfo() {
        ClassLoader cl = this.getServiceClassLoader();
        if (cl instanceof ServiceClassLoader) {
            ServiceClassLoader scl = (ServiceClassLoader)cl;
            scl.setServiceID(this.serviceConfig.getId());
            scl.setServiceVersion(this.serviceConfig.getVersion());
        }
    }

    private void validateDirectoryStructure() throws AgentServiceException {
        if (!this.serviceDirectory.exists() || !this.serviceDirectory.isDirectory()) {
            throw new AgentServiceException("Service directory not found: " + this.serviceDirectory.getName());
        }
        File serviceConfig = new File(this.serviceDirectory, "service-config.xml");
        if (!serviceConfig.exists() || serviceConfig.isDirectory()) {
            throw new AgentServiceException(this.serviceDirectory.getName() + ": service configuration file " + "service-config.xml" + " not found. The service directory will be ignored.");
        }
        File serviceConfigDTD = new File(this.serviceDirectory, "service-config.dtd");
        if (!serviceConfigDTD.exists() || serviceConfigDTD.isDirectory()) {
            throw new AgentServiceException("Service configuration DTD file service-config.dtd not found. The service directory will be ignored.");
        }
    }

    private void validateDirectoryStructure2() throws AgentServiceException {
        if (this.serviceConfig != null) {
            File arlConfig;
            String arl = this.serviceConfig.getArlConfig();
            if (arl != null && (!(arlConfig = new File(this.serviceDirectory, arl)).exists() || arlConfig.isDirectory())) {
                throw new AgentServiceException("ARL configuration file " + arl + " not found. The service directory will be ignored.");
            }
            String mbeanType = this.serviceConfig.getMbeanType();
            if (mbeanType != null && mbeanType.equalsIgnoreCase("Model MBean")) {
                File mbeanDescriptor;
                String mbeanDescriptorXml = this.serviceConfig.getMbeanDescriptor();
                if (mbeanDescriptorXml == null) {
                    mbeanDescriptorXml = DEFAULT_MBEAN_DESCRIPTOR_XML;
                }
                if (!(mbeanDescriptor = new File(this.serviceDirectory, mbeanDescriptorXml)).exists() || mbeanDescriptor.isDirectory()) {
                    throw new AgentServiceException("MBean descriptor XML file " + mbeanDescriptorXml + " not found. The service directory will be ignored.");
                }
            }
        }
    }
}

