/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.services.security.tool;

import com.sybase.ua.services.security.tool.DESKeyFactory;
import com.sybase.ua.services.security.tool.DecryptionKeyManager;
import com.sybase.ua.services.security.tool.EncryptionAlgorithm;
import com.sybase.ua.services.security.tool.InvalidCipherProviderException;
import com.sybase.ua.services.security.tool.KeyCrypt;
import com.sybase.ua.services.security.tool.KeyPairFactory;
import com.sybase.ua.services.security.tool.KeyStoreTool;
import com.sybase.ua.services.security.tool.ProviderManager;
import com.sybase.ua.util.ByteUtil;
import com.sybase.ua.util.StringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class CipherTool
implements EncryptionAlgorithm {
    public static final String DEFAULT_CIPHER = "DES";
    public static final String DEFAULT_TRANSFORMATION = "DES";
    public static final String FIELD_DELIMITER = "{SYUAF}";
    public static final String FIELD_DELIMITER_REGEX = "\\{SYUAF\\}";
    private String provider;
    private String transformation = "DES";
    private Key key;
    private Cipher cipher;
    private static final Map<String, CipherTool> cipherToolMap = new HashMap<String, CipherTool>();
    private static final Map<String, Key> cipherKeyMap = new HashMap<String, Key>();
    private static final KeyCrypt keyCrypt = new KeyCrypt();

    public static byte[] decrypt(byte[] encrypted, String transformation, String keystorePath, String keystoreType, String keystoreProvider, char[] keystorePasswd, String alias, char[] aliasPasswd, boolean usePrivateKey) throws Exception {
        CipherTool cipherTool = new CipherTool(transformation, keystorePath, keystoreType, keystoreProvider, keystorePasswd, alias, aliasPasswd, usePrivateKey);
        cipherTool.init();
        byte[] decrypted = cipherTool.decrypt(encrypted);
        return decrypted;
    }

    public static byte[] decryptFromBase64(byte[] base64EncodedCipherText) throws Exception {
        return CipherTool.decryptFromBase64(base64EncodedCipherText, null, null);
    }

    public static byte[] decryptFromBase64(byte[] base64EncodedCipherText, String alternativeAlgorithm, String alternativeCipherProvider) throws Exception {
        String realCipherText;
        String prvdr;
        String transfm;
        block10: {
            if (base64EncodedCipherText.length == 0) {
                return base64EncodedCipherText;
            }
            String cipherText = new String(Base64.decodeBase64((byte[])base64EncodedCipherText));
            transfm = null;
            prvdr = null;
            realCipherText = null;
            String[] fields = StringUtil.split(cipherText, FIELD_DELIMITER_REGEX);
            if (fields.length < 3) {
                transfm = "DES";
                prvdr = "com.sun.crypto.provider.SunJCE";
                realCipherText = new String(base64EncodedCipherText);
            } else if (fields.length == 3) {
                transfm = fields[0];
                prvdr = fields[1];
                realCipherText = fields[2];
            } else {
                transfm = fields[0];
                prvdr = fields[1];
                realCipherText = fields[2];
                for (int i = 3; i < fields.length - 1; ++i) {
                    realCipherText = new String(realCipherText + fields[i]);
                }
            }
            CipherTool.validateAlgorithm(transfm);
            try {
                ProviderManager.validateProviderClass(prvdr);
            }
            catch (Exception e) {
                if (alternativeAlgorithm == null || alternativeCipherProvider == null || !alternativeAlgorithm.equals(transfm)) break block10;
                try {
                    ProviderManager.validateProviderClass(alternativeCipherProvider);
                    prvdr = alternativeCipherProvider;
                }
                catch (InvalidCipherProviderException icpe) {
                    throw new InvalidCipherProviderException(String.format("Both the original %s and the alternate provider %s are invalid", prvdr, alternativeCipherProvider), (Throwable)icpe);
                }
            }
        }
        Key key = CipherTool.getCachedCipherKey(transfm, prvdr);
        CipherTool cipherTool = CipherTool.getCachedCipherTool(transfm, prvdr, key);
        byte[] newPlainText = cipherTool.decrypt(Base64.decodeBase64((byte[])realCipherText.getBytes()));
        return newPlainText;
    }

    public static byte[] decryptFromBase64(char[] base64EncodedCipherText) throws Exception {
        return CipherTool.decryptFromBase64(ByteUtil.chars2bytes(base64EncodedCipherText));
    }

    public static byte[] decryptFromBase64(char[] base64EncodedCipherText, String alternativeAlgorithm, String alternativeCipherProvider) throws Exception {
        return CipherTool.decryptFromBase64(ByteUtil.chars2bytes(base64EncodedCipherText), alternativeAlgorithm, alternativeCipherProvider);
    }

    public static byte[] decryptFromBase64(char[] base64EncodedCipherText, String transformation, String keystorePath, String keystoreType, String keystoreProvider, char[] keystorePasswd, String alias, char[] aliasPasswd, boolean usePrivateKey) throws Exception {
        CipherTool cipherTool = new CipherTool(transformation, keystorePath, keystoreType, keystoreProvider, keystorePasswd, alias, aliasPasswd, usePrivateKey);
        cipherTool.init();
        byte[] cypherText = Base64.decodeBase64((byte[])ByteUtil.chars2bytes(base64EncodedCipherText));
        byte[] decrypted = cipherTool.decrypt(cypherText);
        return decrypted;
    }

    public static byte[] decryptFromHex(char[] hexEncodedCipherText, String transformation, String keystorePath, String keystoreType, String keystoreProvider, char[] keystorePasswd, String alias, char[] aliasPasswd, boolean usePrivateKey) throws Exception {
        CipherTool cipherTool = new CipherTool(transformation, keystorePath, keystoreType, keystoreProvider, keystorePasswd, alias, aliasPasswd, usePrivateKey);
        cipherTool.init();
        byte[] cypherText = ByteUtil.hex2bytes(hexEncodedCipherText);
        byte[] decrypted = cipherTool.decrypt(cypherText);
        return decrypted;
    }

    public static byte[] encrypt(char[] plainText, String transformation, String keystorePath, String keystoreType, String keystoreProvider, char[] keystorePasswd, String alias, char[] aliasPasswd, boolean usePrivateKey) throws Exception {
        CipherTool cipherTool = new CipherTool(transformation, keystorePath, keystoreType, keystoreProvider, keystorePasswd, alias, aliasPasswd, usePrivateKey);
        cipherTool.init();
        byte[] encrypted = cipherTool.encrypt(plainText);
        return encrypted;
    }

    public static char[] encryptAsBase64(char[] plainText, String transformation, String keystorePath, String keystoreType, String keystoreProvider, char[] keystorePasswd, String alias, char[] aliasPasswd, boolean usePrivateKey) throws Exception {
        byte[] encrypted = CipherTool.encrypt(plainText, transformation, keystorePath, keystoreType, keystoreProvider, keystorePasswd, alias, aliasPasswd, usePrivateKey);
        char[] encoded = ByteUtil.bytes2chars(Base64.encodeBase64((byte[])encrypted));
        return encoded;
    }

    public static char[] encryptAsHex(char[] plainText, String transformation, String keystorePath, String keystoreType, String keystoreProvider, char[] keystorePasswd, String alias, char[] aliasPasswd, boolean usePrivateKey) throws Exception {
        byte[] encrypted = CipherTool.encrypt(plainText, transformation, keystorePath, keystoreType, keystoreProvider, keystorePasswd, alias, aliasPasswd, usePrivateKey);
        char[] encoded = ByteUtil.bytes2hex(encrypted).toCharArray();
        return encoded;
    }

    public static void main(String[] args) {
        String keystorePath = System.getProperty("keystore");
        String keystoreType = System.getProperty("keystore.type");
        String keystoreProvider = System.getProperty("keystore.provider");
        System.out.println("Keystore: " + keystorePath);
        char[] keystorePasswd = null;
        try {
            System.out.print("Enter keystore password: ");
            keystorePasswd = new BufferedReader(new InputStreamReader(System.in)).readLine().toCharArray();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
        String alias = System.getProperty("alias");
        char[] aliasPasswd = null;
        try {
            System.out.print("Enter key password for (" + alias + "): ");
            aliasPasswd = new BufferedReader(new InputStreamReader(System.in)).readLine().toCharArray();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
        char[] plainText = args[0].toCharArray();
        boolean usePrivateKey = "true".equalsIgnoreCase(System.getProperty("use.privatekey"));
        String transformation = null;
        transformation = keystoreType.equalsIgnoreCase("JCEKS") ? "DES" : "RSA";
        try {
            char[] encoded = CipherTool.encryptAsBase64(plainText, transformation, keystorePath, keystoreType, keystoreProvider, keystorePasswd, alias, aliasPasswd, usePrivateKey);
            System.out.println(new String(encoded));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private static Key getCachedCipherKey(String transformation, String providerClass) throws Exception {
        String mapKey = transformation + "/" + providerClass;
        Key key = cipherKeyMap.get(mapKey);
        if (key == null) {
            String encodedPrivateKey = DecryptionKeyManager.getInstance().getDecryptionKey(transformation);
            if (transformation.equalsIgnoreCase("RSA")) {
                KeyPairFactory keypairFactory = new KeyPairFactory(transformation, providerClass);
                key = keypairFactory.generatePrivateKeyFromBase64(keyCrypt.decrypt(encodedPrivateKey));
            } else if (transformation.equalsIgnoreCase("DES")) {
                DESKeyFactory keyFactory = new DESKeyFactory(transformation, providerClass);
                key = keyFactory.generateKeyFromBase64(keyCrypt.decrypt(encodedPrivateKey));
            } else {
                throw new Exception("Unsupported encrytion algorithm (transformation): " + transformation);
            }
            if (key != null) {
                cipherKeyMap.put(mapKey, key);
            }
        }
        return key;
    }

    private static CipherTool getCachedCipherTool(String transformation, String providerClass, Key cipherKey) throws Exception {
        String mapKey = transformation + "/" + providerClass;
        CipherTool cipherTool = cipherToolMap.get(mapKey);
        if (cipherTool == null) {
            cipherTool = new CipherTool(transformation, providerClass, cipherKey);
            cipherTool.init();
            cipherToolMap.put(mapKey, cipherTool);
        }
        return cipherTool;
    }

    public static void validateAlgorithm(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null || algorithm.trim().equals("")) {
            throw new NoSuchAlgorithmException("No alogrithm is provided.");
        }
        if (StringUtil.arrayContainsIgnoreCase(EncryptionAlgorithm.SUPPORTED_ALGORITHMS, algorithm) < 0) {
            throw new NoSuchAlgorithmException("Unknown encryption algorithm: " + algorithm + ". Supported algorithms: " + StringUtil.join(EncryptionAlgorithm.SUPPORTED_ALGORITHMS, ", "));
        }
    }

    public static Provider validateProviderClass(String providerClass) throws InvalidCipherProviderException {
        return ProviderManager.validateProviderClass(providerClass);
    }

    public CipherTool(String transformation, String provider, Key key) {
        if (transformation != null && !transformation.trim().equals("")) {
            this.transformation = transformation;
        }
        if (provider == null || provider.trim().equals("")) {
            if (this.transformation.equalsIgnoreCase("DES")) {
                this.provider = "com.sun.crypto.provider.SunJCE";
            } else if (this.transformation.equalsIgnoreCase("RSA")) {
                this.provider = "com.sun.crypto.provider.SunJCE";
            }
        } else {
            this.provider = provider;
        }
        this.key = key;
    }

    public CipherTool(String keystorePath, String keystoreType, String keystoreProvider, char[] keystorePasswd, String alias, char[] aliasPasswd, boolean usePrivateKey) throws Exception {
        this("DES", keystorePath, keystoreType, keystoreProvider, keystorePasswd, alias, aliasPasswd, usePrivateKey);
    }

    public CipherTool(String transformation, String keystorePath, String keystoreType, String keystoreProvider, char[] keystorePasswd, String alias, char[] aliasPasswd, boolean usePrivateKey) throws Exception {
        Key key = null;
        key = usePrivateKey ? KeyStoreTool.getPrivateKey((String)keystorePath, (String)keystoreType, (String)keystoreProvider, (char[])keystorePasswd, (String)alias, (char[])aliasPasswd) : KeyStoreTool.getPublicKey((String)keystorePath, (String)keystoreType, (String)keystoreProvider, (char[])keystorePasswd, (String)alias, (char[])aliasPasswd);
        this.transformation = transformation;
        this.key = key;
    }

    public byte[] decrypt(byte[] cipherText) throws Exception {
        this.cipher.init(2, this.key);
        byte[] newPlainText = this.cipher.doFinal(cipherText);
        return newPlainText;
    }

    public byte[] decrypt(char[] cipherText) throws Exception {
        return this.decrypt(ByteUtil.chars2bytes(cipherText));
    }

    public byte[] encrypt(byte[] plainText) throws Exception {
        this.cipher.init(1, this.key);
        byte[] cipherText = this.cipher.doFinal(plainText);
        return cipherText;
    }

    public byte[] encrypt(char[] plainText) throws Exception {
        return this.encrypt(ByteUtil.chars2bytes(plainText));
    }

    public char[] encryptAsBase64(byte[] plainText) throws Exception {
        byte[] encrypted = this.encrypt(plainText);
        char[] base64Encoded = ByteUtil.bytes2chars(Base64.encodeBase64((byte[])encrypted));
        String header = this.getTransformation() + FIELD_DELIMITER + this.getProvider() + FIELD_DELIMITER;
        char[] combined = ByteUtil.concatenate(header.toCharArray(), base64Encoded);
        return ByteUtil.bytes2chars(Base64.encodeBase64((byte[])ByteUtil.chars2bytes(combined)));
    }

    public char[] encryptAsBase64(char[] plainText) throws Exception {
        return this.encryptAsBase64(ByteUtil.chars2bytes(plainText));
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public Key getKey() {
        return this.key;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public void init() throws NoSuchAlgorithmException, InvalidCipherProviderException, NoSuchPaddingException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        CipherTool.validateAlgorithm(this.getTransformation());
        Provider providerObj = ProviderManager.validateProviderClass(this.getProvider());
        this.cipher = Cipher.getInstance(this.getTransformation(), providerObj);
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setTransformation(String transformation) {
        this.transformation = transformation;
    }
}

