/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.services.security.tool;

import com.sybase.ua.services.security.tool.EncryptionAlgorithm;
import com.sybase.ua.services.security.tool.ProviderManager;
import com.sybase.ua.util.ByteUtil;
import java.security.Provider;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;

public class DESKeyFactory
implements EncryptionAlgorithm {
    private String algorithm = "DES";
    private String provider = "com.sun.crypto.provider.SunJCE";

    public DESKeyFactory(String algorithm, String provider) {
        if (algorithm != null && !algorithm.trim().equals("")) {
            this.algorithm = algorithm;
        }
        if (provider != null && !provider.trim().equals("")) {
            this.provider = provider;
        }
    }

    public SecretKey generateKey(byte[] keyCode) throws Exception {
        Provider providerObj = ProviderManager.validateProviderClass(this.provider);
        SecretKeyFactory keyFactory = null;
        keyFactory = providerObj != null ? SecretKeyFactory.getInstance(this.algorithm, providerObj) : SecretKeyFactory.getInstance(this.algorithm);
        DESKeySpec keySpec = new DESKeySpec(keyCode);
        SecretKey secretKey = keyFactory.generateSecret(keySpec);
        return secretKey;
    }

    public SecretKey generateKeyFromBase64(String base64EncodedKey) throws Exception {
        return this.generateKey(Base64.decodeBase64((byte[])ByteUtil.string2bytes(base64EncodedKey)));
    }
}

