/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.services.security.tool;

import com.sybase.ua.services.security.tool.DESKeyFactory;
import com.sybase.ua.services.security.tool.EncryptionAlgorithm;
import com.sybase.ua.services.security.tool.KeyCrypt;
import com.sybase.ua.services.security.tool.KeyPairFactory;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;

public class EncryptionKeyManager
implements EncryptionAlgorithm {
    private static EncryptionKeyManager instance;
    private final Map<String, String> keyMap = new HashMap<String, String>();
    private static final String DEFAULT_DES_KEY = "*'X![ H4<LH4V !V~R?v6Pc-AQDWTZx(LKLpIhBQ!5kw$_rK!";
    private static final String DEFAULT_RSA_PUBLIC_KEY = ")YGj[PN./0ap0Bn9!x SSMZtMijz#9-:8H~WQ{]V+q'^jfXQO_!1,z^%$eBEcUh|r!1X)m4o5>Iq~|#lPwCL@+S#+(#.U-E]4hceNDB[VR0eH#H`ih55BALN}/W{:kd!F3{L&_kd7F8+JAT0F{(M`A~M J#z#&$9l}uTk*eU";
    private static final String SECUREOBJECT_DES_KEY = ">$DvQ&'.H@,'K8%[;#<ln|$E`.Ry1UqV.LkE_eN3fv!+G8<k`1/qMaa";
    private static final String SECUREOBJECT_RSA_PUBLIC_KEY = "5BV`@>D%+@M/yV7a{H>6sUE81vnKSTQ.ZW,xwm7D{T1bAqbnmjE}[U:-rJD}YlV&B+REOtLF9Y3N(S{a~{LAOJy M3a$*25<cgXw!3VLoe.Gz2Rec;1tQ$,,A??*mg5z:|I1vd_DOo~5KE1]<9;39in+F5*]C=/&d-Rg&>AM49";
    KeyCrypt keyCrypt = new KeyCrypt();

    public static EncryptionKeyManager getInstance() {
        if (instance == null) {
            instance = new EncryptionKeyManager();
        }
        return instance;
    }

    private EncryptionKeyManager() {
        String defaultDesKey = DEFAULT_DES_KEY;
        String defaultRsaPublicKey = DEFAULT_RSA_PUBLIC_KEY;
        this.keyMap.put("DES", DEFAULT_DES_KEY);
        this.keyMap.put("RSA", DEFAULT_RSA_PUBLIC_KEY);
        this.keyMap.put("DES.SECURE.OBJECT", SECUREOBJECT_DES_KEY);
        this.keyMap.put("RSA.SECURE.OBJECT", SECUREOBJECT_RSA_PUBLIC_KEY);
    }

    public String getEncryptionKey(String algorithm) {
        return this.keyMap.get(algorithm);
    }

    public Key getEncryptionKeyByID(String keyId, String provider) throws Exception {
        String encryptedKey = this.keyMap.get(keyId);
        if (encryptedKey == null) {
            throw new Exception("Key not found: " + keyId);
        }
        String decryptedKey = this.keyCrypt.decrypt(encryptedKey);
        Key key = null;
        if (keyId.equalsIgnoreCase("RSA") || keyId.startsWith("RSA.")) {
            KeyPairFactory keypairFactory = new KeyPairFactory("RSA", provider);
            key = keypairFactory.generatePublicKeyFromBase64(decryptedKey);
        } else if (keyId.equalsIgnoreCase("DES") || keyId.startsWith("DES.")) {
            DESKeyFactory keyFactory = new DESKeyFactory("DES", provider);
            key = keyFactory.generateKeyFromBase64(decryptedKey);
        } else {
            throw new Exception("Invalid key ID: " + keyId);
        }
        return key;
    }
}

