/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.services.security.tool;

import com.sybase.ua.services.security.tool.EncryptionAlgorithm;
import com.sybase.ua.services.security.tool.ProviderManager;
import com.sybase.ua.util.ByteUtil;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class KeyPairFactory
implements EncryptionAlgorithm {
    public static final String DEFAULT_ALGORITHM = "RSA";
    public static final String DEFAULT_PROVIDER = "com.sun.crypto.provider.SunJCE";
    private String algorithm = "RSA";
    private String provider = "com.sun.crypto.provider.SunJCE";
    private final transient Provider _provider;

    public KeyPairFactory(String keyAlgorithm, String provider) {
        if (this.algorithm != null && !this.algorithm.trim().equals("")) {
            this.algorithm = keyAlgorithm;
        }
        if (provider != null && !provider.trim().equals("")) {
            this.provider = provider;
        }
        this._provider = ProviderManager.validateProviderClass(this.provider);
    }

    public PrivateKey generatePrivateKey(byte[] privateKeyCode) throws Exception {
        KeyFactory keyFactory = null;
        keyFactory = this._provider != null ? KeyFactory.getInstance(this.getAlgorithm(), this._provider) : KeyFactory.getInstance(this.getAlgorithm());
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyCode);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return privateKey;
    }

    public PrivateKey generatePrivateKeyFromBase64(String based64EncodedPrivateKey) throws Exception {
        return this.generatePrivateKey(Base64.decodeBase64((byte[])ByteUtil.string2bytes(based64EncodedPrivateKey)));
    }

    public PrivateKey generatePrivateKeyFromHexString(String privateKeyHex) throws Exception {
        return this.generatePrivateKey(ByteUtil.hex2bytes(privateKeyHex));
    }

    public PublicKey generatePublicKey(byte[] pubKeyCode) throws Exception {
        Provider providerObj = this._provider;
        KeyFactory keyFactory = null;
        keyFactory = providerObj != null ? KeyFactory.getInstance(this.getAlgorithm(), providerObj) : KeyFactory.getInstance(this.getAlgorithm());
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyCode);
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        return pubKey;
    }

    public PublicKey generatePublicKeyFromBase64(String base64EncodedPubKeyHex) throws Exception {
        return this.generatePublicKey(Base64.decodeBase64((byte[])ByteUtil.string2bytes(base64EncodedPubKeyHex)));
    }

    public PublicKey generatePublicKeyFromHexString(String pubKeyHex) throws Exception {
        return this.generatePublicKey(ByteUtil.hex2bytes(pubKeyHex));
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getProvider() {
        return this.provider;
    }
}

