/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.services.security.tool;

import com.sybase.ua.services.security.tool.CipherTool;
import com.sybase.ua.services.security.tool.DESKeyFactory;
import com.sybase.ua.services.security.tool.EncryptionAlgorithm;
import com.sybase.ua.services.security.tool.EncryptionKeyManager;
import com.sybase.ua.services.security.tool.KeyCrypt;
import com.sybase.ua.services.security.tool.KeyPairFactory;
import com.sybase.ua.services.security.tool.MaskingThread;
import com.sybase.ua.util.StringUtil;
import com.sybase.ua.util.cli.CLIAppBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.Key;
import java.util.Arrays;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PasswordEncrypt
extends CLIAppBase
implements EncryptionAlgorithm {
    public static final String USAGE = "[-help] [-algorithm <algorithm_name>] [-provider <cipher_provider_class>] [-text <clear_text>]";
    public static final String CL_OPTION_CIPHER = "algorithm";
    public static final String CL_OPTION_CIPHER_DESC = "encryption algorithm, optional. Default value: DES. Supported algorithms: " + StringUtil.join(SUPPORTED_ALGORITHMS, ", ");
    public static final String CL_OPTION_PROVIDER_CLASS = "provider";
    public static final String CL_OPTION_PROVIDER_CLASS_DESC = "cipher provider class, optional. Default DES provider: Sun JCE. Default RSA provider: Sun JCE";
    public static final String CL_OPTION_TEXT = "text";
    public static final String CL_OPTION_TEXT_DESC = "clear text, required.";
    private final EncryptionKeyManager encryptionKeyManager = EncryptionKeyManager.getInstance();
    private final KeyCrypt keyCrypt = new KeyCrypt();

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
        PasswordEncrypt pe = new PasswordEncrypt(args);
        pe.run();
    }

    public PasswordEncrypt(String[] args) {
        super(args);
    }

    public char[] encrypt(char[] plainText, String algorithm, String providerClass) throws Exception {
        String encodedKey = this.encryptionKeyManager.getEncryptionKey(algorithm);
        Key key = null;
        if (algorithm.equalsIgnoreCase("RSA")) {
            KeyPairFactory keypairFactory = new KeyPairFactory(algorithm, providerClass);
            key = keypairFactory.generatePublicKeyFromBase64(this.keyCrypt.decrypt(encodedKey));
        } else if (algorithm.equalsIgnoreCase("DES")) {
            DESKeyFactory keyFactory = new DESKeyFactory(algorithm, providerClass);
            key = keyFactory.generateKeyFromBase64(this.keyCrypt.decrypt(encodedKey));
        } else {
            throw new Exception("Unsupported encrytion algorithm: " + algorithm);
        }
        CipherTool cipherTool = new CipherTool(algorithm, providerClass, key);
        cipherTool.init();
        return cipherTool.encryptAsBase64(plainText);
    }

    public char[] getPassword(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        MaskingThread maskingthread = new MaskingThread(prompt);
        Thread thread = new Thread((Runnable)maskingthread);
        thread.start();
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        maskingthread.stopMasking();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    @Override
    public void printHelp() {
        if (this.getRegisteredOptions() != null) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(" ", this.getRegisteredOptions());
        }
    }

    @Override
    protected Options doRegisterCLOptions() {
        Options clOptions = new Options();
        clOptions.addOption(CL_OPTION_CIPHER, true, CL_OPTION_CIPHER_DESC);
        clOptions.addOption(CL_OPTION_PROVIDER_CLASS, true, CL_OPTION_PROVIDER_CLASS_DESC);
        clOptions.addOption(CL_OPTION_TEXT, true, CL_OPTION_TEXT_DESC);
        return clOptions;
    }

    @Override
    protected void doRun() {
        String text;
        String cipher = this.commandLine.getOptionValue(CL_OPTION_CIPHER);
        if (cipher == null || cipher.trim().equals("")) {
            cipher = "DES";
        }
        String provider = this.commandLine.getOptionValue(CL_OPTION_PROVIDER_CLASS);
        if (cipher.equalsIgnoreCase("RSA")) {
            if (provider == null || provider.trim().equals("")) {
                provider = "org.bouncycastle.jce.provider.BouncyCastleProvider";
            }
        } else if (cipher.equalsIgnoreCase("DES") && (provider == null || provider.trim().equals(""))) {
            provider = "com.sun.crypto.provider.SunJCE";
        }
        if ((text = this.commandLine.getOptionValue(CL_OPTION_TEXT)) == null) {
            try {
                char[] hiddenText = this.getPassword(System.in, "Password: ");
                text = new String(hiddenText);
            }
            catch (IOException ex) {
                System.err.println("Password entry failure.");
                return;
            }
        }
        if (cipher.equalsIgnoreCase("RSA")) {
            try {
                System.out.println(new String(this.encrypt(text.toCharArray(), "RSA", provider)));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Cipher provider class not found: " + e.getMessage());
            }
            catch (Exception e) {
                System.err.println("Failed to encrypt text with algorithm " + cipher + "; " + e.getMessage());
            }
        } else if (cipher.equalsIgnoreCase("DES")) {
            try {
                System.out.println(new String(this.encrypt(text.toCharArray(), "DES", provider)));
            }
            catch (Exception e) {
                System.err.println("Failed to encyrpt text with algorithm " + cipher + "; " + e.getMessage());
            }
        } else {
            System.err.println("Algorithm not supported: " + cipher + ". Currently supported algorithms: " + StringUtil.join(SUPPORTED_ALGORITHMS, ", "));
        }
    }
}

