/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.services.security.tool;

import com.sybase.ua.services.security.tool.InvalidCipherProviderException;
import java.security.Provider;
import java.security.Security;

public class ProviderManager {
    public static Provider validateProviderClass(String provider) throws InvalidCipherProviderException {
        if (provider == null || provider.trim().equals("")) {
            throw new InvalidCipherProviderException("No provider is provided.");
        }
        for (Provider p : Security.getProviders()) {
            if (!p.getClass().getName().equals(provider)) continue;
            return p;
        }
        Class<?> providerClazz = null;
        try {
            providerClazz = ProviderManager.class.getClassLoader().loadClass(provider);
        }
        catch (ClassNotFoundException e) {
            try {
                providerClazz = ClassLoader.getSystemClassLoader().loadClass(provider);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidCipherProviderException("Cipher provider class not found: " + provider, (Throwable)ex);
            }
        }
        try {
            Object providerObj = providerClazz.newInstance();
            if (!(providerObj instanceof Provider)) {
                throw new InvalidCipherProviderException("Cipher provider must be instance of Provider: " + provider);
            }
            Security.addProvider((Provider)providerObj);
            return (Provider)providerObj;
        }
        catch (IllegalAccessException iae) {
            throw new InvalidCipherProviderException("Failed to instantiate provider - Illegal Access" + provider, (Throwable)iae);
        }
        catch (InstantiationException e) {
            throw new InvalidCipherProviderException("Failed to instantiate provider " + provider, (Throwable)e);
        }
    }

    private ProviderManager() {
    }
}

