/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.services.session;

import com.sybase.ua.services.security.SessionContextPrincipal;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;

public class Session
implements Serializable {
    private static final long serialVersionUID = 4085047910090114024L;
    public static final String ANONYMOUS_USER = "anonymous";
    private String sessionID;
    private String username;
    private String clientAddress;
    private String connectionID;
    private final Date timeCreated = new Date();
    private String clientOS;
    private Map<String, Object> clientEnvMap;
    private transient Subject subject;
    private transient Map<?, ?> sessionContextMap;

    public static Session createSession(String username, Subject subject, Map<String, Object> clientEnv) {
        Session session;
        block0: {
            Set<SessionContextPrincipal> sessionContextPrincipals;
            Iterator<SessionContextPrincipal> it;
            session = new Session();
            session.sessionID = session.generateUniqueSessionID();
            session.username = username;
            session.subject = subject;
            session.setClientEnvMap(clientEnv);
            session.clientAddress = clientEnv.get("com.sybase.ua.client.address").toString();
            session.clientOS = clientEnv.get("com.sybase.ua.client.os").toString();
            if (subject == null || !(it = (sessionContextPrincipals = subject.getPrincipals(SessionContextPrincipal.class)).iterator()).hasNext()) break block0;
            SessionContextPrincipal principal = it.next();
            session.setSessionContextMap(principal.getSessionContextMap());
        }
        return session;
    }

    private Session() {
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public Map<String, Object> getClientEnvMap() {
        return this.clientEnvMap;
    }

    public String getClientOS() {
        return this.clientOS;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public String[] getPrincipalNames() {
        if (this.subject == null) {
            return new String[0];
        }
        Set<Principal> principals = this.subject.getPrincipals();
        ArrayList<String> names = new ArrayList<String>(principals.size());
        for (Principal principal : principals) {
            names.add(principal.getName());
        }
        String[] array = names.toArray(new String[names.size()]);
        return array;
    }

    public Map<?, ?> getSessionContextMap() {
        return this.sessionContextMap;
    }

    public String getSessionID() {
        return this.sessionID.toString();
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getUsername() {
        return this.username;
    }

    void invalidate() {
        this.username = null;
        this.subject = null;
        this.clientAddress = null;
        this.clientOS = null;
        if (this.clientEnvMap != null) {
            this.clientEnvMap.clear();
        }
        this.clientEnvMap = null;
        this.sessionContextMap = null;
    }

    public boolean isUserLoggedIn() {
        return this.sessionID != null && this.username != null && !this.username.equals(ANONYMOUS_USER) && this.subject != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Session-ID: " + this.sessionID + " | ");
        sb.append("Username: " + this.username + " | ");
        sb.append("Time-Created: " + this.timeCreated + " | ");
        sb.append("Client-Address: " + this.clientAddress + " | ");
        sb.append("Client-OS: " + this.clientOS);
        return sb.toString();
    }

    public void update(String username, Subject subject) {
        block0: {
            Set<SessionContextPrincipal> sessionContextPrincipals;
            Iterator<SessionContextPrincipal> it;
            this.username = username;
            this.subject = subject;
            if (subject == null || !(it = (sessionContextPrincipals = subject.getPrincipals(SessionContextPrincipal.class)).iterator()).hasNext()) break block0;
            SessionContextPrincipal principal = it.next();
            this.setSessionContextMap(principal.getSessionContextMap());
        }
    }

    private String generateUniqueSessionID() {
        return UUID.randomUUID().toString();
    }

    private void setClientEnvMap(Map<String, Object> clientEnvMap) {
        this.clientEnvMap = clientEnvMap;
    }

    private void setSessionContextMap(Map<?, ?> sessionContextMap) {
        this.sessionContextMap = sessionContextMap;
    }

    public void setConnectionID(String connectionId) {
        this.connectionID = connectionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionID == null ? 0 : this.sessionID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Session other = (Session)obj;
        return !(this.sessionID == null ? other.sessionID != null : !this.sessionID.equals(other.sessionID));
    }
}

