/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;

public class AgentMBeanConvertUtils
extends ConvertUtilsBean {
    private static final EnumConverter enumConverter = new EnumConverter();
    private static final DateConverter dateConverter = new DateConverter();
    private static final ArrayToStringConverter stringConverter = new ArrayToStringConverter();
    private static final AgentMBeanConvertUtils INSTANCE = new AgentMBeanConvertUtils();

    public static AgentMBeanConvertUtils getInstance() {
        return INSTANCE;
    }

    protected AgentMBeanConvertUtils() {
        super.register((Converter)stringConverter, String.class);
    }

    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(Date.class)) {
            return DateFormat.getDateTimeInstance().format((Date)value);
        }
        Converter converter = this.lookup(String.class);
        return (String)converter.convert(String.class, value);
    }

    public Converter lookup(Class clazz) {
        Converter converter = super.lookup(clazz);
        if (converter == null) {
            if (clazz.isEnum()) {
                return enumConverter;
            }
            if (clazz.equals(Date.class)) {
                return dateConverter;
            }
        }
        return converter;
    }

    private static class EnumConverter
    implements Converter {
        private EnumConverter() {
        }

        public Object convert(Class type, Object value) {
            return Enum.valueOf(type, (String)value);
        }
    }

    private static class DateConverter
    implements Converter {
        private DateConverter() {
        }

        public Object convert(Class type, Object value) {
            if (!type.equals(Date.class)) {
                throw new IllegalArgumentException("Expecting Date class");
            }
            try {
                return DateFormat.getDateTimeInstance().parse((String)value);
            }
            catch (ParseException e) {
                throw new RuntimeException("Parse Error '" + value + "'", e);
            }
        }
    }

    private static class ArrayToStringConverter
    implements Converter {
        private ArrayToStringConverter() {
        }

        public Object convert(Class type, Object value) {
            if (!type.equals(String.class)) {
                throw new IllegalArgumentException("Required type = String.class");
            }
            if (value == null) {
                return null;
            }
            if (!value.getClass().isArray()) {
                return value.toString();
            }
            if (value.getClass().getComponentType().equals(Character.TYPE)) {
                char[] ca = (char[])value;
                return new String(ca);
            }
            StringBuilder sb = new StringBuilder("{");
            Iterator<Object> iter = Arrays.asList((Object[])value).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                String s = ConvertUtils.convert((Object)o);
                sb.append(s);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

