/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.EnumSet;

public enum BinaryUnits {
    BYTES(0, "B"),
    KILO(10, "k"),
    MEGA(20, "M"),
    GIGA(30, "G"),
    TERA(40, "T"),
    PETA(50, "P"),
    EXA(60, "E"),
    ZETTA(70, "Z"),
    YOTTA(80, "Y");

    static final BigDecimal TWO;
    private final int factor;
    private final String symbol;

    private BinaryUnits(int factor, String symbol) {
        this.factor = factor;
        this.symbol = symbol;
    }

    public int factor() {
        return this.factor;
    }

    public String symbol() {
        return this.symbol;
    }

    public BigDecimal toBytes(long v) {
        return this.convertTo(BYTES, v);
    }

    public BigDecimal toKilo(long v) {
        return this.convertTo(KILO, v);
    }

    public BigDecimal toMega(long v) {
        return this.convertTo(MEGA, v);
    }

    public BigDecimal toGiga(long v) {
        return this.convertTo(GIGA, v);
    }

    public BigDecimal toTera(long v) {
        return this.convertTo(TERA, v);
    }

    public BigDecimal toPeta(long v) {
        return this.convertTo(PETA, v);
    }

    public BigDecimal toExa(long v) {
        return this.convertTo(EXA, v);
    }

    public BigDecimal toZetta(long v) {
        return this.convertTo(ZETTA, v);
    }

    public BigDecimal toYotta(long v) {
        return this.convertTo(YOTTA, v);
    }

    public BigDecimal toBytes(BigDecimal v) {
        return this.convertTo(BYTES, v);
    }

    public BigDecimal toKilo(BigDecimal v) {
        return this.convertTo(KILO, v);
    }

    public BigDecimal toMega(BigDecimal v) {
        return this.convertTo(MEGA, v);
    }

    public BigDecimal toGiga(BigDecimal v) {
        return this.convertTo(GIGA, v);
    }

    public BigDecimal toTera(BigDecimal v) {
        return this.convertTo(TERA, v);
    }

    public BigDecimal toPeta(BigDecimal v) {
        return this.convertTo(PETA, v);
    }

    public BigDecimal toExa(BigDecimal v) {
        return this.convertTo(EXA, v);
    }

    public BigDecimal toZetta(BigDecimal v) {
        return this.convertTo(ZETTA, v);
    }

    public BigDecimal toYotta(BigDecimal v) {
        return this.convertTo(YOTTA, v);
    }

    public BigDecimal convertTo(BinaryUnits to, long value) {
        return this.convertTo(to, BigDecimal.valueOf(value));
    }

    public BigDecimal convertTo(BinaryUnits to, BigDecimal value) {
        int diffFactor = this.factor - to.factor();
        if (diffFactor > 0) {
            return value.multiply(TWO.pow(diffFactor, MathContext.UNLIMITED));
        }
        if (diffFactor < 0) {
            return value.divide(TWO.pow(Math.abs(diffFactor), MathContext.UNLIMITED));
        }
        return value;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(BYTES.toMega(0x100000L));
        System.out.printf("1 B = %s B\n", BYTES.toBytes(1L));
        System.out.printf("1 KB = %s B\n", KILO.toBytes(1L));
        System.out.printf("1 MB = %s B\n", MEGA.toBytes(1L));
        System.out.printf("1 GB = %s B\n", GIGA.toBytes(1L));
        System.out.printf("1 TB = %s B\n", TERA.toBytes(1L));
        System.out.printf("1 PB = %s B\n", PETA.toBytes(1L));
        System.out.printf("1 XB = %s B\n", EXA.toBytes(1L));
        System.out.printf("1 ZB = %s B\n", ZETTA.toBytes(1L));
        System.out.printf("1 YB = %s B\n", YOTTA.toBytes(1L));
        EnumSet<BinaryUnits> bsus = EnumSet.allOf(BinaryUnits.class);
        for (BinaryUnits bsu : bsus) {
            System.out.printf("1 %s = %s %s\n", bsu.symbol(), bsu.toBytes(1L), BYTES.symbol());
            System.out.printf("1 %s = %s %sB\n", bsu.symbol(), bsu.toKilo(1L), KILO.symbol());
            System.out.printf("1 %s = %s %sB\n", bsu.symbol(), bsu.toMega(1L), MEGA.symbol());
            System.out.printf("1 %s = %s %sB\n", bsu.symbol(), bsu.toGiga(1L), GIGA.symbol());
            System.out.printf("1 %s = %s %sB\n", bsu.symbol(), bsu.toTera(1L), TERA.symbol());
            System.out.printf("1 %s = %s %sB\n", bsu.symbol(), bsu.toPeta(1L), PETA.symbol());
            System.out.printf("1 %s = %s %sB\n", bsu.symbol(), bsu.toExa(1L), EXA.symbol());
            System.out.printf("1 %s = %s %sB\n", bsu.symbol(), bsu.toZetta(1L), ZETTA.symbol());
            System.out.printf("1 %s = %s %sB\n", bsu.symbol(), bsu.toYotta(1L), YOTTA.symbol());
        }
    }

    static {
        TWO = BigDecimal.valueOf(2L);
    }
}

