/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import com.sybase.ua.util.HexUtil;
import java.nio.charset.Charset;

public class ByteUtil {
    public static String DEFAULT_CHARSET_NAME = "utf8";

    public static String byte2hex(byte x) {
        return HexUtil.toHex(x);
    }

    public static char[] bytes2chars(byte[] bytes) {
        Charset charset = Charset.forName(DEFAULT_CHARSET_NAME);
        return ByteUtil.bytes2chars(bytes, charset);
    }

    public static char[] bytes2chars(byte[] bytes, Charset charset) {
        return new String(bytes, charset).toCharArray();
    }

    public static char[] bytes2chars(byte[] bytes, String charsetName) {
        Charset charset = Charset.forName(charsetName);
        return ByteUtil.bytes2chars(bytes, charset);
    }

    public static String bytes2hex(byte[] data) {
        return HexUtil.toHex(data);
    }

    public static byte[] chars2bytes(char[] chars) {
        Charset charset = Charset.forName(DEFAULT_CHARSET_NAME);
        return ByteUtil.chars2bytes(chars, charset);
    }

    public static byte[] chars2bytes(char[] chars, Charset charset) {
        String s = new String(chars);
        byte[] b = s.getBytes(charset);
        return b;
    }

    public static byte[] chars2bytes(char[] chars, String charsetName) {
        Charset charset = Charset.forName(charsetName);
        return ByteUtil.chars2bytes(chars, charset);
    }

    public static void clear(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = 0;
        }
    }

    public static void clear(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = '\u0000';
        }
    }

    public static byte[] concatenate(byte[] b1, byte[] b2) {
        int i;
        byte[] result = new byte[b1.length + b2.length];
        for (i = 0; i < b1.length; ++i) {
            result[i] = b1[i];
        }
        for (i = 0; i < b2.length; ++i) {
            result[b1.length + i] = b2[i];
        }
        return result;
    }

    public static char[] concatenate(char[] b1, char[] b2) {
        int i;
        char[] result = new char[b1.length + b2.length];
        for (i = 0; i < b1.length; ++i) {
            result[i] = b1[i];
        }
        for (i = 0; i < b2.length; ++i) {
            result[b1.length + i] = b2[i];
        }
        return result;
    }

    public static byte hex2byte(String hexString) {
        return (byte)Integer.parseInt(hexString, 16);
    }

    public static byte[] hex2bytes(char[] hex) throws Exception {
        return ByteUtil.hex2bytes(new String(hex));
    }

    public static byte[] hex2bytes(String hexString) throws Exception {
        return HexUtil.toBytes(hexString);
    }

    public static byte[] string2bytes(String text) {
        Charset charset = Charset.forName(DEFAULT_CHARSET_NAME);
        return ByteUtil.string2bytes(text, charset);
    }

    public static byte[] string2bytes(String text, Charset charset) {
        return text.getBytes(charset);
    }

    public static byte[] string2bytes(String text, String charsetName) {
        Charset charset = Charset.forName(charsetName);
        return ByteUtil.string2bytes(text, charset);
    }
}

