/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;

public class CircularBuffer<E>
extends AbstractQueue<E>
implements Queue<E> {
    private final Queue<E> _delegate;
    private final ReentrantLock _lock = new ReentrantLock();

    public CircularBuffer(int capacity) {
        this._delegate = new ArrayBlockingQueue(capacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this._delegate.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        this._lock.lock();
        try {
            if (!this._delegate.offer(e)) {
                this.poll();
                boolean bl = this._delegate.offer(e);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        this._lock.lock();
        try {
            E e = this._delegate.peek();
            return e;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        this._lock.lock();
        try {
            E e = this._delegate.poll();
            return e;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public int size() {
        return this._delegate.size();
    }
}

