/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import com.sybase.ua.util.IBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.TreeSet;

public class CollectionBuilder<T>
implements IBuilder<Collection<T>> {
    private boolean _synchronized = false;
    private boolean _immutable = false;
    protected Collection<T> _collection;

    public static final <T> CollectionBuilder<T> createArrayListBuilder(Class<T> type) {
        return new CollectionBuilder(new ArrayList());
    }

    public static final <T> CollectionBuilder<T> createHashSetBuilder(Class<T> type) {
        return new CollectionBuilder(new HashSet());
    }

    public static final <T> CollectionBuilder<T> createLinkedHashSetBuilder(Class<T> type) {
        return new CollectionBuilder(new LinkedHashSet());
    }

    public static final <T> CollectionBuilder<T> createLinkedListBuilder(Class<T> type) {
        return new CollectionBuilder(new LinkedList());
    }

    public static final <T> CollectionBuilder<T> createTreeSetBuilder(Class<T> type) {
        return new CollectionBuilder(new TreeSet());
    }

    private CollectionBuilder(Collection<T> collection) {
        this._collection = collection;
    }

    public CollectionBuilder<T> add(T value) {
        this._collection.add(value);
        return this;
    }

    @Override
    public Collection<T> build() {
        Collection ret = null;
        try {
            ret = (Collection)this._collection.getClass().newInstance();
            ret.addAll(this._collection);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create new Collection instance of type " + this._collection.getClass(), e);
        }
        if (this._synchronized) {
            this._collection = Collections.synchronizedCollection(this._collection);
        }
        if (this._immutable) {
            this._collection = Collections.unmodifiableCollection(this._collection);
        }
        return this._collection;
    }

    public CollectionBuilder<T> immutable() {
        this._immutable = true;
        return this;
    }

    public CollectionBuilder<T> synchronize() {
        this._synchronized = true;
        return this;
    }
}

