/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class CollectionUtil {
    public static <T> Iterable<T> nullSafe(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.unmodifiableList(new ArrayList(0));
        }
        return iterable;
    }

    public static <T> Iterable<T> nullSafe(T[] iterable) {
        if (iterable == null) {
            return Collections.unmodifiableList(new ArrayList(0));
        }
        return Arrays.asList(iterable);
    }

    public static <E> String toString(Iterable<E> iterable) {
        return CollectionUtil.toString(iterable, ", ", "[", "]");
    }

    public static <E> String toString(Iterable<E> iterable, int maxElements) {
        return CollectionUtil.toString(iterable, ", ", "[", "]", maxElements);
    }

    public static <E> String toString(Iterable<E> iterable, boolean bracket) {
        return CollectionUtil.toString(iterable, ", ", bracket);
    }

    public static <E> String toString(Iterable<E> iterable, boolean bracket, int maxElements) {
        return CollectionUtil.toString(iterable, ", ", bracket, maxElements);
    }

    public static <E> String toString(Iterable<E> iterable, String sep, boolean bracket) {
        return CollectionUtil.toString(iterable, sep != null ? sep : ", ", bracket ? "[" : "", bracket ? "]" : "");
    }

    public static <E> String toString(Iterable<E> iterable, String sep, boolean bracket, int maxElements) {
        return CollectionUtil.toString(iterable, sep != null ? sep : ", ", bracket ? "[" : "", bracket ? "]" : "", maxElements);
    }

    public static <E> String toString(Iterable<E> iterable, String separator, String startBracket, String endBracket) {
        return CollectionUtil.toString(iterable, separator, startBracket, endBracket, Integer.MAX_VALUE);
    }

    public static <E> String toString(Iterable<E> iterable, String separator, String startBracket, String endBracket, int maxElements) {
        String start = startBracket != null ? startBracket : "";
        String end = endBracket != null ? endBracket : "";
        String sep = separator != null && !separator.isEmpty() ? separator : ", ";
        Iterator<E> i = CollectionUtil.nullSafe(iterable).iterator();
        if (!i.hasNext()) {
            return start + end;
        }
        int cnt = 0;
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        while (true) {
            E entry = i.next();
            sb.append(entry);
            if (!i.hasNext()) {
                return sb.append(end).toString();
            }
            if (++cnt >= maxElements) {
                int size = 0;
                if (iterable instanceof Collection) {
                    size = ((Collection)iterable).size();
                } else {
                    size = cnt;
                    while (i.hasNext()) {
                        i.next();
                        ++size;
                    }
                }
                return sb.append(sep).append("...").append(size - maxElements).append(" more...").append(end).toString();
            }
            sb.append(sep);
        }
    }
}

