/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.math.BigDecimal;
import java.math.MathContext;

public enum DecimalUnits {
    YOTTA(24, "Y"),
    ZETTA(21, "Z"),
    EXA(18, "E"),
    PETA(15, "P"),
    TERA(12, "T"),
    GIGA(9, "G"),
    MEGA(6, "M"),
    KILO(3, "k"),
    HECTO(2, "h"),
    DEKA(1, "da"),
    DECI(-1, "d"),
    CENTI(-2, "c"),
    MILLI(-3, "m"),
    MICRO(-6, "\u00b5"),
    NANO(-9, "n"),
    PICO(-12, "p"),
    FENTO(-15, "f"),
    ATTO(-18, "a"),
    ZEPTO(-21, "z"),
    YOCTO(-24, "y");

    private final int factor;
    private final String symbol;

    private DecimalUnits(int factor, String symbol) {
        this.factor = factor;
        this.symbol = symbol;
    }

    public int factor() {
        return this.factor;
    }

    public String symbol() {
        return this.symbol;
    }

    public BigDecimal convertTo(DecimalUnits to, long value) {
        return this.convertTo(to, BigDecimal.valueOf(value));
    }

    public BigDecimal convertTo(DecimalUnits to, BigDecimal value) {
        if (this.factor() > to.factor()) {
            int diffFactor = this.factor - to.factor();
            return value.multiply(BigDecimal.TEN.pow(diffFactor, MathContext.UNLIMITED));
        }
        if (this.factor() < to.factor()) {
            int diffFactor = this.factor - to.factor();
            return value.divide(BigDecimal.TEN.pow(diffFactor, MathContext.UNLIMITED));
        }
        return value;
    }

    public BigDecimal toDeka(long v) {
        return this.convertTo(DEKA, v);
    }

    public BigDecimal toHecto(long v) {
        return this.convertTo(HECTO, v);
    }

    public BigDecimal toKilo(long v) {
        return this.convertTo(KILO, v);
    }

    public BigDecimal toMega(long v) {
        return this.convertTo(MEGA, v);
    }

    public BigDecimal toGiga(long v) {
        return this.convertTo(GIGA, v);
    }

    public BigDecimal toTera(long v) {
        return this.convertTo(TERA, v);
    }

    public BigDecimal toPeta(long v) {
        return this.convertTo(PETA, v);
    }

    public BigDecimal toExa(long v) {
        return this.convertTo(EXA, v);
    }

    public BigDecimal toZetta(long v) {
        return this.convertTo(ZETTA, v);
    }

    public BigDecimal toYotta(long v) {
        return this.convertTo(YOTTA, v);
    }

    public BigDecimal toDeci(long v) {
        return this.convertTo(DECI, v);
    }

    public BigDecimal toCenti(long v) {
        return this.convertTo(CENTI, v);
    }

    public BigDecimal toMilli(long v) {
        return this.convertTo(MILLI, v);
    }

    public BigDecimal toMicro(long v) {
        return this.convertTo(MICRO, v);
    }

    public BigDecimal toNano(long v) {
        return this.convertTo(NANO, v);
    }

    public BigDecimal toPico(long v) {
        return this.convertTo(PICO, v);
    }

    public BigDecimal toFento(long v) {
        return this.convertTo(FENTO, v);
    }

    public BigDecimal toAtto(long v) {
        return this.convertTo(ATTO, v);
    }

    public BigDecimal toZepto(long v) {
        return this.convertTo(ZEPTO, v);
    }

    public BigDecimal toYocto(long v) {
        return this.convertTo(YOCTO, v);
    }

    public BigDecimal toDeka(BigDecimal v) {
        return this.convertTo(DEKA, v);
    }

    public BigDecimal toHecto(BigDecimal v) {
        return this.convertTo(HECTO, v);
    }

    public BigDecimal toKilo(BigDecimal v) {
        return this.convertTo(KILO, v);
    }

    public BigDecimal toMega(BigDecimal v) {
        return this.convertTo(MEGA, v);
    }

    public BigDecimal toGiga(BigDecimal v) {
        return this.convertTo(GIGA, v);
    }

    public BigDecimal toTera(BigDecimal v) {
        return this.convertTo(TERA, v);
    }

    public BigDecimal toPeta(BigDecimal v) {
        return this.convertTo(PETA, v);
    }

    public BigDecimal toExa(BigDecimal v) {
        return this.convertTo(EXA, v);
    }

    public BigDecimal toZetta(BigDecimal v) {
        return this.convertTo(ZETTA, v);
    }

    public BigDecimal toYotta(BigDecimal v) {
        return this.convertTo(YOTTA, v);
    }

    public BigDecimal toDeci(BigDecimal v) {
        return this.convertTo(DECI, v);
    }

    public BigDecimal toCenti(BigDecimal v) {
        return this.convertTo(CENTI, v);
    }

    public BigDecimal toMilli(BigDecimal v) {
        return this.convertTo(MILLI, v);
    }

    public BigDecimal toMicro(BigDecimal v) {
        return this.convertTo(MICRO, v);
    }

    public BigDecimal toNano(BigDecimal v) {
        return this.convertTo(NANO, v);
    }

    public BigDecimal toPico(BigDecimal v) {
        return this.convertTo(PICO, v);
    }

    public BigDecimal toFento(BigDecimal v) {
        return this.convertTo(FENTO, v);
    }

    public BigDecimal toAtto(BigDecimal v) {
        return this.convertTo(ATTO, v);
    }

    public BigDecimal toZepto(BigDecimal v) {
        return this.convertTo(ZEPTO, v);
    }

    public BigDecimal toYocto(BigDecimal v) {
        return this.convertTo(YOCTO, v);
    }
}

