/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static final Log log = LogFactory.getLog(FileUtil.class);

    public static File sanitizedFile(File dir, String relativePath) throws PathTraversalException, IOException {
        String rpath;
        String string = rpath = relativePath == null ? "" : relativePath.trim();
        if (rpath.length() == 0) {
            return dir;
        }
        if (new File(rpath).isAbsolute()) {
            throw new PathTraversalException(dir, rpath);
        }
        String canonicalDirPath = dir.getCanonicalPath();
        String canonicalDirFilePath = new File(dir, rpath).getCanonicalPath();
        if (!canonicalDirFilePath.startsWith(canonicalDirPath)) {
            throw new PathTraversalException(dir, rpath);
        }
        return new File(canonicalDirFilePath);
    }

    public static boolean isInSubdirectory(String dir, String fpath) throws IllegalStateException {
        return FileUtil.isInSubdirectory(dir, new File(fpath));
    }

    public static boolean isInSubdirectory(String dir, File f) throws IllegalStateException {
        return FileUtil.isInSubdirectory(new File(dir), f);
    }

    public static boolean isInSubdirectory(File dir, String fpath) throws IllegalStateException {
        return FileUtil.isInSubdirectory(dir, new File(fpath));
    }

    public static boolean isInSubdirectory(File dir, File f) throws IllegalStateException {
        if (dir == null || f == null) {
            return false;
        }
        try {
            String canonicalDirPath = dir.getCanonicalPath();
            String canonicalFilePath = f.getCanonicalPath();
            return canonicalFilePath.startsWith(canonicalDirPath);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to convert file to canonical path", ioe);
        }
    }

    public static void copyDir(File sourceDir, File targetDir, boolean verbose) throws IOException {
        FileUtil.copyDir(sourceDir, targetDir, verbose, null);
    }

    public static void copyDir(File sourceDir, File targetDir, boolean verbose, FilenameFilter filter) throws IOException {
        File[] files;
        for (File file : files = sourceDir.listFiles(filter)) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File tgtDir = new File(targetDir, file.getName());
                if (!tgtDir.exists()) {
                    tgtDir.mkdirs();
                    if (verbose) {
                        log.debug((Object)("Created directory " + tgtDir.getAbsolutePath()));
                    }
                }
                FileUtil.copyDir(file, tgtDir, verbose);
                continue;
            }
            if (file.isFile()) {
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                    if (verbose) {
                        log.debug((Object)("Created directory " + targetDir.getAbsolutePath()));
                    }
                }
                File tgtFile = new File(targetDir, file.getName());
                FileUtil.copyFile(file, tgtFile);
                if (!verbose) continue;
                log.debug((Object)("Updated file " + tgtFile.getAbsolutePath()));
                continue;
            }
            log.debug((Object)("Skipping unknown type of file: " + file.getAbsolutePath()));
        }
    }

    public static void copyFile(File src, File tgt) throws IOException {
        if (!src.exists()) {
            throw new IOException("Source file " + src.getPath() + " not found.");
        }
        FileInputStream is = new FileInputStream(src);
        FileOutputStream os = new FileOutputStream(tgt);
        byte[] buf = new byte[1024];
        int bytes = 0;
        while ((bytes = ((InputStream)is).read(buf)) > 0) {
            ((OutputStream)os).write(buf, 0, bytes);
        }
        os.flush();
        ((OutputStream)os).close();
        ((InputStream)is).close();
    }

    public static boolean deleteDir(String directoryPath) throws IOException {
        if (directoryPath == null || directoryPath.equals("")) {
            throw new IOException("The directory path can not be null or blank");
        }
        File directoryFile = new File(directoryPath);
        if (!directoryFile.exists()) {
            return false;
        }
        return FileUtil.deleteDir(1, directoryFile);
    }

    public static File getDir(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                return f;
            }
            return f.getParentFile();
        }
        String p = f.getAbsolutePath();
        String dirPath = FileUtil.getDir(p);
        return new File(dirPath);
    }

    public static String getDir(String absolutePath) {
        String separator = File.separator;
        String p = FileUtil.removeTrailingSeparator(absolutePath);
        int idx = p.lastIndexOf(separator);
        if (idx < 0) {
            return null;
        }
        String d = p.substring(0, idx);
        return d;
    }

    public static String getFileBaseName(String filename) {
        String fn = FileUtil.getJustFileName(filename);
        if (fn == null) {
            return null;
        }
        int i = fn.lastIndexOf(".");
        if (i < 0) {
            return fn;
        }
        if (i == 0) {
            return fn;
        }
        String rv = fn.substring(0, i);
        return rv;
    }

    public static String getJustFileName(String filePath) {
        String separator = System.getProperty("file.separator");
        int i = filePath.lastIndexOf(separator);
        if (i <= 0) {
            return filePath;
        }
        if (i == filePath.length() - 1) {
            return null;
        }
        String rv = filePath.substring(i + 1);
        if (rv != null) {
            rv = rv.trim();
        }
        return rv;
    }

    public static byte[] readFileAsByteArray(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        int size = fis.available();
        byte[] data = new byte[size];
        fis.read(data);
        fis.close();
        return data;
    }

    public static byte[] readFileAsByteArray(String filepath) throws IOException {
        File f = new File(filepath);
        return FileUtil.readFileAsByteArray(f);
    }

    public static String readFileAsString(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File does not exist: " + file.getAbsolutePath());
        }
        StringBuffer sb = new StringBuffer();
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        isr.close();
        fis.close();
        return sb.toString();
    }

    public static String readInputStreamAsString(InputStream inputStream) throws IOException {
        StringBuffer sb = new StringBuffer();
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        isr.close();
        return sb.toString();
    }

    public static String removeTrailingSeparator(String dirPath) {
        String ret = new String(dirPath);
        String separator = File.separator;
        if (dirPath.substring(dirPath.length() - 1).equals(separator)) {
            ret = dirPath.substring(0, dirPath.length() - 1);
        }
        return ret;
    }

    public static void versionedBackup(File srcFile, String backupExtension) throws IOException {
        FileUtil.versionedBackup(srcFile, backupExtension, 50);
    }

    public static void versionedBackup(File srcFile, String backupExtension, int maxNumberOfBackups) throws IOException {
        if (!srcFile.exists()) {
            throw new IOException("Source file " + srcFile.getPath() + " not found.");
        }
        final File backupFile = new File(srcFile.getAbsolutePath() + "." + backupExtension);
        if (!backupFile.exists()) {
            FileUtil.copyFile(srcFile, backupFile);
        } else {
            File bakFile;
            File parentFile = srcFile.getParentFile();
            String[] backupFiles = parentFile.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean accept = false;
                    if (name.startsWith(backupFile.getName())) {
                        accept = true;
                    }
                    return accept;
                }
            });
            int latestVersion = 1;
            Pattern pattern = Pattern.compile("\\.(\\d+)$");
            for (String backupFile2 : backupFiles) {
                Matcher matcher = pattern.matcher(backupFile2);
                if (!matcher.find()) continue;
                String ver = matcher.group(1);
                try {
                    Integer verInt = new Integer(ver);
                    if (verInt <= latestVersion) continue;
                    latestVersion = verInt;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int nextVersion = latestVersion + 1;
            if (nextVersion > maxNumberOfBackups) {
                FileUtil.rotateBackupFiles(backupFile, maxNumberOfBackups, latestVersion);
                nextVersion = maxNumberOfBackups;
            }
            if ((bakFile = new File(srcFile.getAbsolutePath() + "." + backupExtension + "." + new Integer(nextVersion).toString())).exists()) {
                bakFile.delete();
            }
            FileUtil.copyFile(srcFile, bakFile);
        }
    }

    public static synchronized void writeFile(String content, File f, boolean append) throws IOException {
        File dir = FileUtil.getDir(f);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileWriter fw = new FileWriter(f, append);
        PrintWriter printWriter = new PrintWriter(fw);
        printWriter.print(content);
        printWriter.close();
        fw.close();
    }

    private static boolean deleteDir(int level, File file) throws IOException {
        if (file.isFile()) {
            if (!file.delete()) {
                log.error((Object)("[" + level + "] File " + file.getAbsolutePath() + " could not be deleted."));
                return false;
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int ndx = 0; ndx < fileList.length; ++ndx) {
                if (FileUtil.deleteDir(level + 1, fileList[ndx])) continue;
                return false;
            }
            if (!file.delete()) {
                log.error((Object)("[" + level + "] File " + file.getAbsolutePath() + " could not be deleted."));
                return false;
            }
        } else {
            throw new IOException("Unknown file type:" + file.getPath());
        }
        return true;
    }

    private static void rotateBackupFiles(File backupFile, int maxNumberOfBackups, int latestVersion) throws IOException {
        int i;
        int excessive = latestVersion - maxNumberOfBackups;
        for (i = 1; i <= maxNumberOfBackups; ++i) {
            File target = null;
            target = i == 1 ? backupFile : new File(backupFile.getAbsolutePath() + "." + i);
            File src = null;
            src = new File(backupFile.getAbsolutePath() + "." + (i + excessive + 1));
            if (!src.exists()) continue;
            if (target.exists()) {
                target.delete();
            }
            src.renameTo(target);
        }
        for (i = maxNumberOfBackups + 1; i <= maxNumberOfBackups + excessive; ++i) {
            File f = new File(backupFile.getAbsolutePath() + "." + i);
            if (!f.exists()) continue;
            f.delete();
        }
    }

    public static class PathTraversalException
    extends IOException {
        private static final long serialVersionUID = 1L;

        static String asCanonicalPath(File f) {
            try {
                return f != null ? f.getCanonicalPath() : "null";
            }
            catch (IOException ioe) {
                return f.getAbsolutePath();
            }
        }

        protected PathTraversalException() {
        }

        public PathTraversalException(File dir, String rpath) {
            super("The specified path (" + rpath + ") is a " + (new File(rpath).isAbsolute() ? "absolute" : "relative") + " path to a location outside of the specified base directory (" + PathTraversalException.asCanonicalPath(dir) + ").");
        }
    }
}

