/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import com.sybase.ua.config.AppenderConfig;
import com.sybase.ua.config.LoggerConfig;
import com.sybase.ua.config.PropertyConfig;
import com.sybase.ua.util.ReflectionUtil;
import com.sybase.ua.util.StringUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Log4JHelper {
    public static final String[] SUPPORTED_LEVELS = new String[]{Level.OFF.toString(), Level.FATAL.toString(), Level.ERROR.toString(), Level.WARN.toString(), Level.INFO.toString(), Level.DEBUG.toString(), Level.TRACE.toString()};
    public static final String DEFAULT_APPENDER = "org.apache.log4j.DailyRollingFileAppender";
    public static final String DEFAULT_DATE_PATTERN = ".yyyy-MM-dd";
    public static final String DEFAULT_LAYOUT = "%d [%-5p] [%t] %c.%M(%L) - %m%n";
    private static final Log log = LogFactory.getLog(Log4JHelper.class);

    public static AppenderConfig createDailyRollingFileAppender(String logFileName) {
        AppenderConfig appenderConfig = new AppenderConfig();
        appenderConfig.setClassname(DEFAULT_APPENDER);
        appenderConfig.addProperty("file", logFileName);
        appenderConfig.addProperty("datePattern", DEFAULT_DATE_PATTERN);
        appenderConfig.addProperty("layout", DEFAULT_LAYOUT, "org.apache.log4j.Layout");
        return appenderConfig;
    }

    public static boolean isLevelValid(String level) {
        int idx = StringUtil.arrayContains(SUPPORTED_LEVELS, level.toUpperCase());
        return idx >= 0;
    }

    public static void processLoggerAppenders(Logger logger, List<AppenderConfig> appenders, File logBaseDir, ClassLoader classloader) {
        if (appenders != null && !appenders.isEmpty()) {
            logger.removeAllAppenders();
            for (AppenderConfig appenderConfig2 : appenders) {
                AppenderConfig appenderConfig = appenderConfig2;
                String classname = appenderConfig.getClassname();
                if (classname == null) {
                    log.error((Object)"Logger appender classname not defined.");
                    continue;
                }
                classname = classname.trim();
                Appender appender = null;
                Class<?> appenderClass = null;
                try {
                    appenderClass = classloader.loadClass(classname);
                    Object obj = appenderClass.newInstance();
                    if (!(obj instanceof Appender)) {
                        log.error((Object)("Appender class does not implement Appender: " + classname));
                        continue;
                    }
                    appender = (Appender)obj;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.error((Object)e.toString(), (Throwable)e);
                        continue;
                    }
                    log.error((Object)e.toString());
                    continue;
                }
                List<PropertyConfig> props = appenderConfig.getProperties();
                if (props != null && !props.isEmpty()) {
                    Iterator<PropertyConfig> i$ = props.iterator();
                    while (i$.hasNext()) {
                        PropertyConfig propertyConfig;
                        PropertyConfig propConfig = propertyConfig = i$.next();
                        String propName = propConfig.getName();
                        String propValue = propConfig.getValue();
                        String propType = propConfig.getType();
                        Class paramType = null;
                        Object paramValue = null;
                        if (propType.equals("org.apache.log4j.Layout")) {
                            paramType = Layout.class;
                            paramValue = new PatternLayout(propValue);
                        } else if (propType.equals("java.lang.Boolean")) {
                            paramType = Boolean.class;
                            paramValue = new Boolean(propValue);
                        } else if (propType.equals("java.lang.Integer")) {
                            paramType = Integer.class;
                            paramValue = new Integer(propValue);
                        } else if (propType.equals("java.lang.String")) {
                            if (propName.equals("file")) {
                                File logFile = new File(logBaseDir, propValue.toString());
                                if (!logFile.getParentFile().exists()) {
                                    logFile.getParentFile().mkdirs();
                                }
                                paramValue = logFile.getAbsolutePath();
                            } else {
                                paramValue = propValue;
                            }
                            paramType = String.class;
                        } else {
                            log.error((Object)("Unsupported property type: " + propType));
                            continue;
                        }
                        String method = "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
                        try {
                            ReflectionUtil.invoke(appender, method, new Class[]{paramType}, new Object[]{paramValue});
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to set appender property " + propName));
                            if (log.isDebugEnabled()) {
                                log.error((Object)e.toString(), (Throwable)e);
                                continue;
                            }
                            log.error((Object)e.toString());
                        }
                    }
                }
                String method = "activateOptions";
                if (ReflectionUtil.hasMethod(appender, "activateOptions", null)) {
                    try {
                        ReflectionUtil.invoke(appender, "activateOptions", null, null);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to activate appender options ");
                        if (log.isDebugEnabled()) {
                            log.error((Object)e.toString(), (Throwable)e);
                            continue;
                        }
                        log.error((Object)e.toString());
                        continue;
                    }
                }
                logger.addAppender(appender);
                log.debug((Object)("Added appender: " + classname));
            }
        }
    }

    public static void processLoggers(Map<String, LoggerConfig> loggers, File logBaseDir, ClassLoader classloader) {
        String systemLogLevelProp = System.getProperty("com.sybase.ua.log.level", "").trim().toUpperCase();
        for (LoggerConfig loggerConfig : loggers.values()) {
            String loggerName = loggerConfig.getName();
            String loggerLevel = loggerConfig.getLevel();
            boolean loggerAdditivity = loggerConfig.isAdditivity();
            List<AppenderConfig> appenders = loggerConfig.getAppenders();
            if (loggerName == null || loggerName.trim().equals("") || loggerLevel == null || loggerLevel.trim().equals("")) continue;
            loggerName = loggerName.trim();
            loggerLevel = loggerLevel.trim().toUpperCase();
            Logger logger = Logger.getLogger((String)loggerName);
            if (logger == null) continue;
            if (loggerLevel != null && !loggerLevel.isEmpty()) {
                logger.setLevel(Level.toLevel((String)loggerLevel));
                log.debug((Object)("Set logger: " + loggerName + ", level set as " + loggerLevel));
            } else if (systemLogLevelProp != null && !systemLogLevelProp.isEmpty()) {
                logger.setLevel(Level.toLevel((String)systemLogLevelProp.trim()));
                log.debug((Object)("Set logger: " + loggerName + ", level set as system level: " + systemLogLevelProp.trim()));
            } else {
                logger.setLevel(Level.WARN);
            }
            logger.setAdditivity(loggerAdditivity);
            Log4JHelper.processLoggerAppenders(logger, appenders, logBaseDir, classloader);
        }
    }

    public static void validateLoggerNames(Map<String, LoggerConfig> loggers, String basePackageName, ClassLoader classloader) throws Exception {
        for (LoggerConfig loggerConfig2 : loggers.values()) {
            LoggerConfig loggerConfig = loggerConfig2;
            String loggerName = loggerConfig.getName();
            if (loggerName == null || loggerName.startsWith(basePackageName)) continue;
            throw new Exception("Invalid logger name: " + loggerName + ". It must be " + basePackageName + " or its subpackage or class name resided within the package.");
        }
    }
}

