/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

public class LogUtil {
    public static final String INFO = "INFO";
    public static final String DEBUG = "DEBUG";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    private boolean debugEnabled = false;

    public LogUtil() {
    }

    public LogUtil(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            System.out.println(msg);
        }
    }

    public void debug(String message, Throwable t) {
        System.out.println(message);
        if (t != null) {
            t.printStackTrace();
        }
    }

    public void debug(Throwable t) {
        this.debug(t.getMessage(), t);
    }

    public void error(String msg) {
        System.out.println(msg);
    }

    public void error(String msg, Throwable t) {
        System.out.println(msg);
        t.printStackTrace();
    }

    public void error(Throwable t) {
        t.printStackTrace();
    }

    public void info(String msg) {
        System.out.println(msg);
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void warn(String msg) {
        System.out.println(msg);
    }
}

