/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingPrintWriter
extends PrintWriter {
    private final Logger logger;
    private final Level level;
    private final CharBuffer buffer;

    public LoggingPrintWriter(Logger logger, Level level) {
        this(logger, level, 2048, new PrintWriter(new NullOutputStream()));
    }

    public LoggingPrintWriter(Logger logger, Level level, int bufferSize, Writer out) {
        super(out);
        this.logger = logger;
        this.level = level;
        this.buffer = CharBuffer.allocate(bufferSize);
    }

    public LoggingPrintWriter(Logger logger, Level level, Writer out) {
        this(logger, level, 2048, out);
    }

    @Override
    public void close() {
        this.buffer.clear();
        super.close();
    }

    @Override
    public void flush() {
        super.flush();
        int pos = this.buffer.position();
        this.buffer.rewind();
        if (pos == 0) {
            return;
        }
        CharSequence cs = this.buffer.subSequence(0, pos);
        if (this.logger.isEnabledFor((Priority)this.level)) {
            this.logger.log((Priority)this.level, (Object)((Object)cs).toString());
        }
        this.buffer.rewind();
    }

    @Override
    public void println() {
        super.println();
        this.flush();
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        if (this.logger.isEnabledFor((Priority)this.level)) {
            for (int i = 0; i < len; ++i) {
                this.write(buf[i + off]);
            }
        } else {
            super.write(buf, off, len);
        }
    }

    @Override
    public void write(int c) {
        super.write(c);
        if (this.logger.isEnabledFor((Priority)this.level)) {
            if ((char)c == '\r' || (char)c == '\n') {
                this.flush();
            } else {
                if (this.buffer.remaining() == 0) {
                    this.flush();
                }
                this.buffer.append((char)c);
            }
        }
    }

    @Override
    public void write(String s) {
        this.write(s, 0, s.length());
    }

    @Override
    public void write(String s, int off, int len) {
        this.write(s.toCharArray(), off, len);
    }

    private static final class NullOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
        }
    }
}

