/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import com.sybase.ua.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] md5sum(File f) {
        byte[] byArray;
        FileInputStream fis = null;
        FileChannel fc = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            fis = new FileInputStream(f);
            fc = fis.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            md5.update(bb);
            byArray = md5.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                throw new IllegalStateException(nsae);
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.close(fis);
                throw throwable;
            }
        }
        StreamUtil.close(fis);
        return byArray;
    }

    public static final byte[] md5sum(InputStream is) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bb = new byte[8192];
            int read = -1;
            while ((read = is.read(bb)) != -1) {
                md5.update(bb, 0, read);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        finally {
            StreamUtil.close(is);
        }
    }

    public static final byte[] md5sum(byte[] input) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] byArray = md5.digest(input);
            return byArray;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
    }

    public static final byte[] md5sum(String input) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] byArray = md5.digest(input.getBytes());
            return byArray;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
    }

    private MD5() {
    }
}

