/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import com.sybase.ua.util.IBuilder;
import com.sybase.ua.util.PropertiesBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class MapBuilder<K, V>
implements IBuilder<Map<K, V>> {
    private boolean _synchronized = false;
    private boolean _immutable = false;
    private final Map<K, V> _map;

    public static final <K, V> MapBuilder<K, V> createConcurrentMapBuilder(Class<K> keyType, Class<V> valType) {
        return new MapBuilder(new ConcurrentHashMap());
    }

    public static final <K, V> MapBuilder<K, V> createHashMapBuilder(Class<K> keyType, Class<V> valType) {
        return new MapBuilder(new HashMap());
    }

    public static final <K, V> MapBuilder<K, V> createLinkedHashMapBuilder(Class<K> keyType, Class<V> valType) {
        return new MapBuilder(new LinkedHashMap());
    }

    public static final PropertiesBuilder createPropertiesBuilder() {
        return new PropertiesBuilder(new Properties());
    }

    public static final PropertiesBuilder createPropertiesBuilder(Properties defaults) {
        return new PropertiesBuilder(defaults);
    }

    public static final <K, V> MapBuilder<K, V> createTreeMapBuilder(Class<K> keyType, Class<V> valType) {
        return new MapBuilder(new TreeMap());
    }

    private MapBuilder(Map<K, V> map) {
        this._map = map;
    }

    @Override
    public Map<K, V> build() {
        Map<K, V> ret = null;
        try {
            ret = (Map<K, V>)this._map.getClass().newInstance();
            ret.putAll(this._map);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create new Map instance of type " + this._map.getClass(), e);
        }
        if (this._synchronized) {
            ret = Collections.synchronizedMap(ret);
        }
        if (this._immutable) {
            ret = Collections.unmodifiableMap(ret);
        }
        return ret;
    }

    public MapBuilder<K, V> immutable() {
        this._immutable = true;
        return this;
    }

    public MapBuilder<K, V> put(K key, V value) {
        this._map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> synchronize() {
        this._synchronized = true;
        return this;
    }
}

