/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtil {
    public static InetAddress getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static InetAddress getLocalInetAddress(String addr) {
        try {
            InetAddress iaddr = InetAddress.getByName(addr);
            Enumeration<NetworkInterface> eint = NetworkInterface.getNetworkInterfaces();
            while (eint.hasMoreElements()) {
                NetworkInterface ni = eint.nextElement();
                Enumeration<InetAddress> eaddr = ni.getInetAddresses();
                while (eaddr.hasMoreElements()) {
                    InetAddress localAddress = eaddr.nextElement();
                    if (!iaddr.equals(localAddress)) continue;
                    return iaddr;
                }
            }
        }
        catch (SocketException se) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isLocalAddr(String addr) {
        boolean ret = false;
        try {
            InetAddress iaddr = InetAddress.getByName(addr);
            ret = NetUtil.isLocalInetAddr(iaddr);
        }
        catch (UnknownHostException uhe) {
            ret = false;
        }
        return ret;
    }

    public static boolean isLocalInetAddr(InetAddress iaddr) {
        boolean ret = false;
        try {
            Enumeration<NetworkInterface> eint = NetworkInterface.getNetworkInterfaces();
            block2: while (eint.hasMoreElements() && !ret) {
                NetworkInterface ni = eint.nextElement();
                Enumeration<InetAddress> eaddr = ni.getInetAddresses();
                while (eaddr.hasMoreElements()) {
                    InetAddress localAddress = eaddr.nextElement();
                    if (!iaddr.equals(localAddress)) continue;
                    ret = true;
                    continue block2;
                }
            }
        }
        catch (SocketException se) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortInUse(InetAddress address, Integer port) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, 0, address);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    public static boolean isPortInUse(String address, Integer port) {
        InetAddress iaddress = null;
        if (address != null) {
            try {
                iaddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid host address " + address);
            }
        }
        return NetUtil.isPortInUse(iaddress, port);
    }

    public static boolean isSystemPort(Integer port) {
        return port > 0 && port <= 1024;
    }

    public static boolean isValidPortNumber(Integer port) {
        return port >= 0 && port <= 65535;
    }

    public static void main(String[] args) {
        if (args.length > 1 && args[0].equalsIgnoreCase("testlocal")) {
            if (NetUtil.isLocalAddr(args[1])) {
                System.exit(0);
            } else {
                System.exit(-1);
            }
        } else {
            System.out.println("Valid args:");
            System.out.println("testlocal <addr>");
            System.exit(-2);
        }
    }
}

