/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class PackageVersion {
    public static final String ARG_VERSION_LONG = "-version";
    public static final String ARG_VERSION_SHORT = "-v";

    public static String getName(File jarFile) {
        String name = null;
        try {
            Attributes attributes;
            JarFile jar;
            Manifest manifest;
            if (jarFile.exists() && jarFile.canRead() && (manifest = (jar = new JarFile(jarFile)).getManifest()) != null && (attributes = manifest.getMainAttributes()) != null) {
                name = attributes.getValue("Implementation-Title");
            }
        }
        catch (IOException ioe) {
            name = null;
        }
        return name;
    }

    public static String getServerName(File serverJarFile) {
        String serverName = PackageVersion.getName(serverJarFile);
        if (serverName == null) {
            serverName = "Sybase Control Center Server (development)";
        }
        return serverName;
    }

    public static String getServerVersion(File serverJarFile) {
        return PackageVersion.getServerName(serverJarFile) + " " + PackageVersion.getServerVersionNumber(serverJarFile);
    }

    public static String getServerVersionNumber(File serverJarFile) {
        String versionNumberString = PackageVersion.getVersionNumber(serverJarFile);
        if (versionNumberString == null) {
            versionNumberString = "3.2.2.4514";
        }
        return versionNumberString;
    }

    public static String getVersionNumber(File jarFile) {
        String versionNumberString = null;
        try {
            Attributes attributes;
            JarFile jar;
            Manifest manifest;
            if (jarFile.exists() && jarFile.canRead() && (manifest = (jar = new JarFile(jarFile)).getManifest()) != null && (attributes = manifest.getMainAttributes()) != null) {
                versionNumberString = attributes.getValue("Implementation-Version");
            }
        }
        catch (IOException ioe) {
            versionNumberString = null;
        }
        return versionNumberString;
    }

    public static void main(String[] args) {
        PackageVersion packageVersion = new PackageVersion();
        packageVersion.processArguments(args);
    }

    private void outputVersionInfo() {
        Package pluginPackage = this.getClass().getPackage();
        String vendorName = pluginPackage.getImplementationVendor();
        String pluginName = pluginPackage.getImplementationTitle();
        String pluginVersion = pluginPackage.getImplementationVersion();
        System.out.println(vendorName + " - " + pluginName + " (" + pluginVersion + ")");
    }

    private void processArguments(String[] args) {
        if (args != null) {
            for (String arg : args) {
                if (!arg.equalsIgnoreCase(ARG_VERSION_LONG) && !arg.equalsIgnoreCase(ARG_VERSION_SHORT)) continue;
                this.outputVersionInfo();
                System.exit(0);
            }
        }
        System.out.println("Usage: [ -v | -version ] ");
    }
}

