/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import com.sybase.ua.plugin.AgentPluginMBean;
import com.sybase.ua.util.MapBuilder;
import com.sybase.ua.util.VersionNumber;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluginVersionNumberParser {
    public static final Logger log = Logger.getLogger(PluginVersionNumberParser.class);
    public static final IPluginVersionNumberParser SCCTESTER;
    public static final IPluginVersionNumberParser SCCMAP;
    public static final IPluginVersionNumberParser RMAP;
    public static final IPluginVersionNumberParser ASEMAP;
    public static final IPluginVersionNumberParser ASEAP;
    public static final IPluginVersionNumberParser IQMAP;
    public static final IPluginVersionNumberParser IQAP;
    public static final IPluginVersionNumberParser SYSAMAP;
    public static final Map<String, IPluginVersionNumberParser> PLUGIN_PARSER;

    public static final VersionNumber parseVersionNumber(AgentPluginMBean plugin, String configFileVersion) {
        String implementationVersion = plugin.getClass().getPackage().getImplementationVersion();
        if (implementationVersion == null) {
            return VersionNumber.createVersion(configFileVersion);
        }
        implementationVersion = implementationVersion.trim();
        try {
            IPluginVersionNumberParser parser = PLUGIN_PARSER.get(plugin.getClass().getPackage().getName());
            if (parser == null) {
                return VersionNumber.createVersion(implementationVersion);
            }
            return parser.parse(plugin, configFileVersion, implementationVersion);
        }
        catch (Exception e) {
            log.warn((Object)("Manifest Implementation-Version number format parsing failed for plugin '" + plugin.getId() + "': " + implementationVersion + ".  Using plugin config file version (" + configFileVersion + ")"));
            return VersionNumber.createVersion(configFileVersion);
        }
    }

    static {
        SCCMAP = SCCTESTER = new IPluginVersionNumberParser(){

            @Override
            public VersionNumber parse(AgentPluginMBean plugin, String configFileVersion, String implementationVersion) {
                String v = implementationVersion.split(" ")[0];
                return VersionNumber.createVersion(v);
            }
        };
        RMAP = new IPluginVersionNumberParser(){

            @Override
            public VersionNumber parse(AgentPluginMBean plugin, String configFileVersion, String implementationVersion) {
                String v = implementationVersion.split("/")[1];
                return VersionNumber.createVersion(v);
            }
        };
        ASEMAP = new IPluginVersionNumberParser(){

            @Override
            public VersionNumber parse(AgentPluginMBean plugin, String configFileVersion, String implementationVersion) {
                String[] vc = implementationVersion.split("/");
                String v = vc[4] + "." + vc[6];
                return VersionNumber.createVersion(v);
            }
        };
        ASEAP = new IPluginVersionNumberParser(){

            @Override
            public VersionNumber parse(AgentPluginMBean plugin, String configFileVersion, String implementationVersion) {
                return VersionNumber.createVersion(implementationVersion);
            }
        };
        IQMAP = new IPluginVersionNumberParser(){

            @Override
            public VersionNumber parse(AgentPluginMBean plugin, String configFileVersion, String implementationVersion) {
                if (implementationVersion.contains(" build ")) {
                    String[] vs = implementationVersion.split(" build ");
                    String buildNum = vs[1].split(",")[0];
                    return VersionNumber.createVersion(String.format("%s.%s", vs[0], buildNum));
                }
                String v = implementationVersion.split("/")[3];
                return VersionNumber.createVersion(v);
            }
        };
        IQAP = new IPluginVersionNumberParser(){

            @Override
            public VersionNumber parse(AgentPluginMBean plugin, String configFileVersion, String implementationVersion) {
                String v = implementationVersion.split("/")[3];
                return VersionNumber.createVersion(v);
            }
        };
        SYSAMAP = new IPluginVersionNumberParser(){

            @Override
            public VersionNumber parse(AgentPluginMBean plugin, String configFileVersion, String implementationVersion) {
                return VersionNumber.createVersion(implementationVersion);
            }
        };
        PLUGIN_PARSER = MapBuilder.createHashMapBuilder(String.class, IPluginVersionNumberParser.class).put("com.sybase.ua.plugins.scctest", SCCTESTER).put("com.sybase.ua.plugins.sccmap", SCCMAP).put("com.sybase.ua.plugins.rmap", RMAP).put("com.sybase.ua.plugins.asemap", ASEMAP).put("com.sybase.ua.plugins.ase", ASEAP).put("com.sybase.ua.plugins.iqmap", IQMAP).put("com.sybase.ua.plugins.iqap", IQAP).put("com.sybase.ua.plugins.sysam", SYSAMAP).immutable().build();
    }

    public static interface IPluginVersionNumberParser {
        public VersionNumber parse(AgentPluginMBean var1, String var2, String var3);
    }
}

