/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.io.Serializable;

public class ProcessInfo
implements Serializable {
    static final long serialVersionUID = -8195727410000224730L;
    public static final String MODE_SYNCHRONOUS = "SYNCHRONOUS";
    public static final String MODE_ASYNCHRONOUS = "ASYNCHRONOUS";
    public static final String STATUS_UNKNOWN = "UNKNOWN";
    public static final String STATUS_FAILED = "FAILED";
    public static final String STATUS_FINISHED = "FINISHED";
    public static final String STATUS_RUNNING = "RUNNING";
    public static final String STATUS_ABORTED = "ABORTED";
    public static final int EXIT_VALUE_UNKNOWN = -9999;
    private int exitValue = -9999;
    private String command;
    private String status = "UNKNOWN";
    private final StringBuffer outputBuffer = new StringBuffer();
    private String executionMode = "SYNCHRONOUS";
    private long timeStarted;
    private long timeFinished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputMessage(String msg) {
        StringBuffer stringBuffer = this.outputBuffer;
        synchronized (stringBuffer) {
            this.outputBuffer.append(msg);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String getExecutionMode() {
        return this.executionMode;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getOutput() {
        if (this.outputBuffer == null) {
            return "";
        }
        return this.outputBuffer.toString();
    }

    public StringBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public String getStatus() {
        return this.status;
    }

    public int getTimeElapsed() {
        int timeElapsed = (int)(this.timeFinished - this.timeStarted);
        return timeElapsed;
    }

    public long getTimeFinished() {
        return this.timeFinished;
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setExecutionMode(String executionMode) {
        this.executionMode = executionMode;
    }

    public void setExitValue(int exitValue) {
        this.exitValue = exitValue;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTimeFinished(long timeFinished) {
        this.timeFinished = timeFinished;
    }

    public void setTimeStarted(long timeStarted) {
        this.timeStarted = timeStarted;
    }

    public String toString() {
        return this.getOutput();
    }
}

