/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import com.sybase.ua.util.IBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class PropertiesBuilder
implements IBuilder<Properties> {
    private final Properties _defaults;
    private final Properties _properties;
    private boolean _immutable = false;

    public static SortedMap<String, String> sortProperties(Properties properties) {
        TreeMap<String, String> sortedProps = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String val = e.getValue() != null ? e.getValue().toString() : null;
            sortedProps.put(e.getKey().toString(), val);
        }
        return sortedProps;
    }

    public static Map<String, String> extract(Map<String, String> from, String keyFilter) {
        return PropertiesBuilder.extract(from, keyFilter, false);
    }

    public static Map<String, String> extract(Map<String, String> from, String keyFilter, boolean exclude) {
        TreeMap<String, String> extracted = new TreeMap<String, String>(from);
        Iterator iterator = extracted.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            boolean matches = ((String)e.getKey()).matches(keyFilter);
            if (exclude) {
                if (!matches) continue;
                iterator.remove();
                continue;
            }
            if (matches) continue;
            iterator.remove();
        }
        return extracted;
    }

    public PropertiesBuilder() {
        this(null);
    }

    public PropertiesBuilder(Properties defaults) {
        this._defaults = defaults;
        this._properties = new Properties(defaults);
    }

    @Override
    public Properties build() {
        if (this._immutable) {
            return new UnmodifiableProperties(this._properties);
        }
        Properties p = new Properties(this._defaults);
        p.putAll((Map<?, ?>)this._properties);
        return p;
    }

    public PropertiesBuilder immutable() {
        this._immutable = true;
        return this;
    }

    public PropertiesBuilder load(InputStream is) throws IOException {
        this._properties.load(is);
        return this;
    }

    public PropertiesBuilder load(Reader is) throws IOException {
        this._properties.load(is);
        return this;
    }

    public PropertiesBuilder loadFromXML(InputStream is) throws IOException {
        this._properties.loadFromXML(is);
        return this;
    }

    public PropertiesBuilder put(String key, String value) {
        return this.setProperty(key, value);
    }

    public PropertiesBuilder setProperty(String key, String value) {
        this._properties.setProperty(key, value);
        return this;
    }

    public static final class UnmodifiableProperties
    extends Properties {
        private static final long serialVersionUID = -792957971193898320L;
        private final Map<Object, Object> _umodifiableDelegate;
        private final Properties _originalWithDefaults;

        public UnmodifiableProperties(Properties delegate) {
            this._originalWithDefaults = delegate;
            HashMap<Object, Object> tmp = new HashMap<Object, Object>(delegate);
            this._umodifiableDelegate = Collections.synchronizedMap(Collections.unmodifiableMap(tmp));
        }

        @Override
        public void clear() {
            this._umodifiableDelegate.clear();
        }

        @Override
        public Object clone() {
            return this._originalWithDefaults.clone();
        }

        @Override
        public boolean contains(Object value) {
            return this._originalWithDefaults.contains(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this._umodifiableDelegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this._umodifiableDelegate.containsValue(value);
        }

        @Override
        public Enumeration<Object> elements() {
            return this._originalWithDefaults.elements();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this._umodifiableDelegate.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this._umodifiableDelegate).equals(o);
        }

        @Override
        public Object get(Object key) {
            return this._umodifiableDelegate.get(key);
        }

        @Override
        public String getProperty(String key) {
            return this._originalWithDefaults.getProperty(key);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            return this._originalWithDefaults.getProperty(key, defaultValue);
        }

        @Override
        public int hashCode() {
            return ((Object)this._umodifiableDelegate).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this._umodifiableDelegate.isEmpty();
        }

        @Override
        public Enumeration<Object> keys() {
            return this._originalWithDefaults.keys();
        }

        @Override
        public Set<Object> keySet() {
            return this._umodifiableDelegate.keySet();
        }

        @Override
        public void list(PrintStream out) {
            this._originalWithDefaults.list(out);
        }

        @Override
        public void list(PrintWriter out) {
            this._originalWithDefaults.list(out);
        }

        @Override
        public synchronized void load(InputStream inStream) throws IOException {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public synchronized void load(Reader reader) throws IOException {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public Enumeration<?> propertyNames() {
            return this._originalWithDefaults.propertyNames();
        }

        @Override
        public Object put(Object key, Object value) {
            return this._umodifiableDelegate.put(key, value);
        }

        @Override
        public void putAll(Map<? extends Object, ? extends Object> m) {
            this._umodifiableDelegate.putAll(m);
        }

        @Override
        public Object remove(Object key) {
            return this._umodifiableDelegate.remove(key);
        }

        @Override
        @Deprecated
        public void save(OutputStream out, String comments) {
            this._originalWithDefaults.save(out, comments);
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int size() {
            return this._umodifiableDelegate.size();
        }

        @Override
        public void store(OutputStream out, String comments) throws IOException {
            this._originalWithDefaults.store(out, comments);
        }

        @Override
        public void store(Writer writer, String comments) throws IOException {
            this._originalWithDefaults.store(writer, comments);
        }

        @Override
        public void storeToXML(OutputStream os, String comment) throws IOException {
            this._originalWithDefaults.storeToXML(os, comment);
        }

        @Override
        public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
            this._originalWithDefaults.storeToXML(os, comment, encoding);
        }

        @Override
        public Set<String> stringPropertyNames() {
            return this._originalWithDefaults.stringPropertyNames();
        }

        @Override
        public String toString() {
            return this._originalWithDefaults.toString();
        }

        @Override
        public Collection<Object> values() {
            return this._umodifiableDelegate.values();
        }
    }
}

