/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class StreamUtil {
    public static final void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readFully(InputStream is) throws IOException {
        byte[] ret = new byte[8192];
        byte[] buffer = new byte[1024];
        int read = 0;
        int pos = 0;
        try {
            byte[] tmp;
            while ((read = is.read(buffer)) != -1) {
                if (ret.length < pos + read) {
                    tmp = new byte[ret.length * 2];
                    System.arraycopy(ret, 0, tmp, 0, pos);
                    ret = tmp;
                }
                System.arraycopy(buffer, 0, ret, pos, read);
                pos += read;
            }
            if (pos == 0) {
                tmp = new byte[]{};
                return tmp;
            }
            tmp = new byte[pos];
            System.arraycopy(ret, 0, tmp, 0, pos);
            byte[] byArray = tmp;
            return byArray;
        }
        finally {
            StreamUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StringBuffer readFully(Reader r) throws IOException {
        StringWriter sw = new StringWriter(2048);
        char[] buffer = new char[1024];
        int read = 0;
        int pos = 0;
        try {
            while ((read = r.read(buffer)) != -1) {
                sw.write(buffer, 0, read);
                pos += read;
            }
            if (pos == 0) {
                StringBuffer stringBuffer = new StringBuffer(0);
                return stringBuffer;
            }
            StringBuffer stringBuffer = sw.getBuffer();
            return stringBuffer;
        }
        finally {
            StreamUtil.close(r);
            StreamUtil.close(sw);
        }
    }

    public static final StringBuffer readText(File f) throws IOException {
        FileReader fr = new FileReader(f);
        return StreamUtil.readFully(fr);
    }

    public static final long transferFile(File f, OutputStream os) throws IOException {
        return StreamUtil.transferFile(f, os, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long transferFile(File f, OutputStream os, int bufferSize) throws IOException {
        long total = 0L;
        int len = 0;
        byte[] buffer = new byte[bufferSize];
        FileInputStream is = new FileInputStream(f);
        try {
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
                total += (long)len;
            }
            os.flush();
            long l = total;
            return l;
        }
        finally {
            StreamUtil.close(is);
        }
    }

    public static final long transferFile(File f, Writer os) throws IOException {
        return StreamUtil.transferFile(f, os, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long transferFile(File f, Writer os, int bufferSize) throws IOException {
        long total = 0L;
        int len = 0;
        char[] buffer = new char[bufferSize];
        FileReader is = new FileReader(f);
        try {
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
                total += (long)len;
            }
            os.flush();
            long l = total;
            return l;
        }
        finally {
            StreamUtil.close(is);
        }
    }

    private StreamUtil() {
    }
}

