/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class StringUtil {
    public static List<String> array2list(String[] a) {
        return Arrays.asList(Arrays.copyOf(a, a.length));
    }

    public static int arrayContains(String[] a, String s) {
        int idx = -1;
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(s)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public static <T extends Comparable<T>> T[] copyAndSort(T[] a) {
        Object[] copy = (Comparable[])Arrays.copyOf(a, a.length);
        Arrays.sort(copy);
        return copy;
    }

    public static int arrayContainsIgnoreCase(String[] a, String s) {
        int idx = -1;
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equalsIgnoreCase(s)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public static String[] arrayShift(String[] array) {
        String[] shiftedArray = null;
        if (array == null || array.length == 0) {
            shiftedArray = null;
        } else {
            shiftedArray = new String[array.length - 1];
            for (int i = 0; i < shiftedArray.length; ++i) {
                shiftedArray[i] = array[i + 1];
            }
        }
        return shiftedArray;
    }

    public static String fixSize(String inputString, int length) {
        return StringUtil.fixSize(inputString, length, "...", " ");
    }

    public static String fixSize(String inputString, int length, String displayMore) {
        return StringUtil.fixSize(inputString, length, displayMore, " ");
    }

    public static String fixSize(String inputString, int length, String displayMore, String padding) {
        String result = null;
        int origLength = inputString.length();
        result = origLength == length ? inputString : (origLength > length ? StringUtil.truncate(inputString, length, displayMore) : StringUtil.pad(inputString, length, padding));
        return result;
    }

    public static String fixSize(String[] stringArray, int[] lengthArray) {
        return StringUtil.fixSize(stringArray, lengthArray, "...", " ");
    }

    public static String fixSize(String[] stringArray, int[] lengthArray, String displayMore) {
        return StringUtil.fixSize(stringArray, lengthArray, displayMore, " ");
    }

    public static String fixSize(String[] stringArray, int[] lengthArray, String displayMore, String padding) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            sb.append(StringUtil.fixSize(stringArray[i], lengthArray[i], displayMore, padding));
        }
        return sb.toString();
    }

    public static boolean isInteger(String s) {
        boolean isInteger = false;
        if (s == null || s.trim().equals("")) {
            return false;
        }
        try {
            new Integer(s.trim());
            isInteger = true;
        }
        catch (Exception e) {
            isInteger = false;
        }
        return isInteger;
    }

    public static String join(Iterable<String> a) {
        return StringUtil.join(a, ",");
    }

    public static String join(Iterable<String> a, String glue) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> ai = a.iterator();
        while (ai.hasNext()) {
            sb.append(ai.next());
            if (!ai.hasNext()) continue;
            sb.append(glue);
        }
        return sb.toString();
    }

    public static String join(String[] a, String glue) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            sb.append(a[i]);
            if (i >= a.length - 1) continue;
            sb.append(glue);
        }
        return sb.toString();
    }

    public static String[] split(String s, String delim) {
        String[] splitted = s.split(delim);
        List<String> list = StringUtil.array2list(splitted);
        if (s.endsWith(delim)) {
            list.add("");
        }
        return list.toArray(new String[list.size()]);
    }

    private static String pad(String inputString, int length, String padding) {
        StringBuffer pad = new StringBuffer(padding);
        for (int i = 0; i < (length - inputString.length()) / padding.length(); ++i) {
            pad.append(padding);
        }
        return inputString + pad.toString().substring(0, length - inputString.length());
    }

    private static String truncate(String inputString, int length, String displayMore) {
        String result = inputString.substring(0, length - displayMore.length()) + displayMore;
        return result;
    }

    public static String chomp(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        int lastIdx = s.length() - 1;
        char lastChar = s.charAt(lastIdx);
        if (lastIdx == 0 && (lastChar == '\r' || lastChar == '\n')) {
            return "";
        }
        if (lastChar == '\n') {
            if (s.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (lastChar != '\r') {
            return s;
        }
        return s.substring(0, lastIdx);
    }

    public static String chompAll(String s) {
        char lastChar;
        int lastIdx;
        if (s == null || s.isEmpty()) {
            return s;
        }
        for (lastIdx = s.length(); lastIdx > 0 && ((lastChar = s.charAt(lastIdx - 1)) == '\r' || lastChar == '\n'); --lastIdx) {
        }
        if (lastIdx == s.length()) {
            return s;
        }
        return s.substring(0, lastIdx);
    }

    public static String toUpper(String orig, int firstChar) {
        return StringUtil.toUpper(orig, firstChar, firstChar);
    }

    public static String toUpper(String orig, int firstChar, int toChar) {
        StringBuffer sb = new StringBuffer(orig);
        for (int i = firstChar; i <= Math.min(orig.length() - 1, toChar); ++i) {
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    public static String toLower(String orig, int firstChar) {
        return StringUtil.toLower(orig, firstChar, firstChar);
    }

    public static String toLower(String orig, int firstChar, int toChar) {
        StringBuffer sb = new StringBuffer(orig);
        for (int i = firstChar; i <= Math.min(orig.length() - 1, toChar); ++i) {
            sb.setCharAt(i, Character.toLowerCase(sb.charAt(i)));
        }
        return sb.toString();
    }
}

