/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

public class VersionNumber
implements Comparable<VersionNumber> {
    private final int _major;
    private final int _minor;
    private final int _micro;
    private final int _build;
    private final String _fullVersionString;
    private final String _shortVersionString;

    public static final int compareVersions(VersionNumber version, Integer major, Integer ... versionNumbers) {
        VersionNumber cmpV = VersionNumber.createVersion(major, versionNumbers);
        return version.compareTo(cmpV);
    }

    public static final int compareVersions(VersionNumber version, String versionString) {
        VersionNumber cmpV = VersionNumber.createVersion(versionString);
        return version.compareTo(cmpV);
    }

    public static final VersionNumber createVersion(Integer major, Integer ... versionNumbers) {
        int minor = versionNumbers.length > 0 ? versionNumbers[0] : 0;
        int micro = versionNumbers.length > 1 ? versionNumbers[1] : 0;
        int build = versionNumbers.length > 2 ? versionNumbers[2] : 0;
        return VersionNumber.createVersion(major, (Integer)minor, (Integer)micro, (Integer)build);
    }

    public static final VersionNumber createVersion(Integer major, Integer minor, Integer micro, Integer build) throws IllegalArgumentException {
        return new VersionNumber(major, minor, micro, build);
    }

    public static final VersionNumber createVersion(String versionString) throws IllegalArgumentException {
        return new VersionNumber(versionString);
    }

    public static final VersionNumber createVersion(int[] version) {
        if (version.length != 4) {
            throw new IllegalArgumentException("Incorrect array size");
        }
        int major = version[0];
        int minor = version[1];
        int micro = version[2];
        int build = version[3];
        return new VersionNumber(major, minor, micro, build);
    }

    public VersionNumber(Integer major, Integer minor, Integer micro, Integer build) {
        this._major = major;
        this._minor = minor != null ? minor : 0;
        this._micro = micro != null ? micro : 0;
        this._build = build != null ? build : 0;
        this._fullVersionString = String.format("%d.%d.%d.%d", this._major, this._minor, this._micro, this._build);
        this._shortVersionString = String.format("%d.%d.%d", this._major, this._minor, this._micro);
    }

    public VersionNumber(String versionString) throws IllegalArgumentException {
        String[] toks = versionString.split("\\.");
        try {
            this._major = Integer.valueOf(toks[0].trim());
            this._minor = toks.length >= 2 ? this.parseVersionNumberComponent(toks[1], false, 0) : 0;
            this._micro = toks.length >= 3 ? this.parseVersionNumberComponent(toks[2], false, 0) : 0;
            this._build = toks.length >= 4 ? this.parseVersionNumberComponent(toks[3], false, 0) : 0;
            this._fullVersionString = String.format("%d.%d.%d.%d", this._major, this._minor, this._micro, this._build);
            this._shortVersionString = String.format("%d.%d.%d", this._major, this._minor, this._micro);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Failed to parse version string '" + versionString + "'.  Expected format is major.minor.micro.buildnum");
        }
    }

    public int compareBuildNumber(VersionNumber version) {
        return this.getBuild() - version.getBuild();
    }

    public int compareMajor(VersionNumber version) {
        return this.getMajor() - version.getMajor();
    }

    public int compareMicro(VersionNumber version) {
        int dmaj = this.getMajor() - version.getMajor();
        if (dmaj != 0) {
            return dmaj;
        }
        int dmin = this.getMinor() - version.getMinor();
        if (dmin != 0) {
            return dmin;
        }
        return this.getMicro() - version.getMicro();
    }

    public int compareMinor(VersionNumber version) {
        int dmaj = this.getMajor() - version.getMajor();
        if (dmaj != 0) {
            return dmaj;
        }
        return this.getMinor() - version.getMinor();
    }

    @Override
    public int compareTo(VersionNumber version) {
        int dmaj = this.getMajor() - version.getMajor();
        if (dmaj != 0) {
            return dmaj;
        }
        int dmin = this.getMinor() - version.getMinor();
        if (dmin != 0) {
            return dmin;
        }
        int dmic = this.getMicro() - version.getMicro();
        if (dmic != 0) {
            return dmic;
        }
        return this.getBuild() - version.getBuild();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        if (this._major != other._major) {
            return false;
        }
        if (this._minor != other._minor) {
            return false;
        }
        if (this._micro != other._micro) {
            return false;
        }
        return this._build == other._build;
    }

    public int getBuild() {
        return this._build;
    }

    public String getFullVersionString() {
        return this._fullVersionString;
    }

    public int getMajor() {
        return this._major;
    }

    public int getMicro() {
        return this._micro;
    }

    public int getMinor() {
        return this._minor;
    }

    public String getShortVersionString() {
        return this._shortVersionString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._major;
        result = 31 * result + this._minor;
        result = 31 * result + this._micro;
        result = 31 * result + this._build;
        return result;
    }

    public int[] toArray() {
        return new int[]{this._major, this._minor, this._micro, this._build};
    }

    public String toString() {
        return this._fullVersionString;
    }

    protected Integer parseVersionNumberComponent(String tok) {
        return this.parseVersionNumberComponent(tok, false, 0);
    }

    protected Integer parseVersionNumberComponent(String tok, boolean required, Integer defaultValue) {
        Integer val;
        block4: {
            val = defaultValue;
            try {
                if (tok == null) {
                    if (!required) {
                        return defaultValue;
                    }
                    throw new NullPointerException("token required");
                }
                val = Integer.valueOf(tok.trim());
            }
            catch (NumberFormatException nfe) {
                if (!required) break block4;
                throw nfe;
            }
        }
        return val;
    }
}

