/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util;

import com.sybase.ua.util.VersionNumber;

public class VersionRange {
    private final VersionNumber _from;
    private final VersionNumber _to;

    public VersionRange(VersionNumber from, VersionNumber to) {
        this._from = from;
        this._to = to;
    }

    public int compareToRange(VersionNumber v) {
        int cmpF = v.compareTo(this._from);
        if (cmpF < 0) {
            return cmpF;
        }
        int cmpT = v.compareTo(this._to);
        if (cmpT > 0) {
            return cmpT;
        }
        return 0;
    }

    public boolean encompasses(VersionRange inner) {
        return this._from.compareTo(inner.getFrom()) <= 0 && this._to.compareTo(inner.getTo()) >= 0;
    }

    public VersionNumber getFrom() {
        return this._from;
    }

    public VersionNumber getTo() {
        return this._to;
    }

    public boolean isInRange(VersionNumber v) {
        return this.compareToRange(v) == 0;
    }

    public String toString() {
        return String.format("%s to %s", this._from, this._to);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._from == null ? 0 : this._from.hashCode());
        result = 31 * result + (this._to == null ? 0 : this._to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        if (this._from == null ? other._from != null : !this._from.equals(other._from)) {
            return false;
        }
        return !(this._to == null ? other._to != null : !this._to.equals(other._to));
    }
}

