/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.cli;

import com.sybase.ua.util.cli.CLIApp;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CLIAppBase
implements CLIApp {
    protected Log log = LogFactory.getLog(this.getClass());
    protected Options registeredOptions = this.doRegisterCLOptions();
    protected CommandLine commandLine;
    private final String[] args;

    public CLIAppBase(String[] args) {
        this.args = args;
        if (!this.registeredOptions.hasOption("help")) {
            this.registeredOptions.addOption("help", false, "print help");
        }
        if (!this.registeredOptions.hasOption("H")) {
            this.registeredOptions.addOption("H", false, "print help");
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    @Override
    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    @Override
    public Options getRegisteredOptions() {
        return this.registeredOptions;
    }

    public void printArgs() {
        if (this.args == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (String arg : this.args) {
            sb.append(arg);
            sb.append(" ");
        }
        this.log.debug((Object)("Arguments: " + sb.toString()));
    }

    @Override
    public void printHelp() {
        if (this.getRegisteredOptions() != null) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java " + this.getClass().getName(), this.getRegisteredOptions());
        }
    }

    @Override
    public void run() {
        BasicParser clParser = new BasicParser();
        try {
            this.commandLine = clParser.parse(this.registeredOptions, this.args);
        }
        catch (ParseException e) {
            this.log.error((Object)e.toString());
            this.printHelp();
            return;
        }
        if (this.commandLine.hasOption("help") || this.commandLine.hasOption("H")) {
            this.printHelp();
            return;
        }
        this.doRun();
    }

    protected abstract Options doRegisterCLOptions();

    protected abstract void doRun();
}

