/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.util.concurrent;

import com.sybase.ua.util.concurrent.CancellableTask;
import com.sybase.ua.util.concurrent.TaskTimer;
import com.sybase.ua.util.concurrent.TimedFutureTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class BlockingThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger _logger = Logger.getLogger(BlockingThreadPoolExecutor.class);
    private final ThreadLocal<Long> _startTime = new ThreadLocal();
    private final AtomicLong _taskCount = new AtomicLong();
    private final AtomicLong _totalTime = new AtomicLong();

    public BlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxPendingTaskQueueSize, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new ArrayBlockingQueue<Runnable>(maxPendingTaskQueueSize), threadFactory, new BlockingPolicy());
        super.allowCoreThreadTimeOut(true);
    }

    public BlockingThreadPoolExecutor(int maximumPoolSize, int maxPendingTaskQueueSize, ThreadFactory threadFactory) {
        this(maximumPoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, maxPendingTaskQueueSize, threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            long completedTimeN = System.nanoTime();
            long taskTime = completedTimeN - this._startTime.get();
            this._taskCount.incrementAndGet();
            this._totalTime.addAndGet(taskTime);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Thread %s: Task %s completed. Elapsed %dns", t, r, taskTime));
            }
        }
        finally {
            super.afterExecute(r, t);
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Thread %s: Starting task %s", t, r));
        }
        this._startTime.set(System.nanoTime());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof CancellableTask) {
            return ((CancellableTask)callable).newTask();
        }
        return super.newTaskFor(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void terminated() {
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Terminated", new Object[0]));
            }
        }
        finally {
            super.terminated();
        }
    }

    public static class BlockingPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable command, ThreadPoolExecutor executor) {
            block9: {
                if (executor.isShutdown()) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)String.format("Task %s rejected because executor %s is shutdown.", command, this));
                    }
                    return;
                }
                try {
                    if (command instanceof Future && ((Future)((Object)command)).isCancelled()) {
                        throw new CancellationException(String.format("Task %s is cancelled", command));
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)String.format("Attempting to queue rejected task %s after purge", command));
                    }
                    executor.purge();
                    if (command instanceof TimedFutureTask) {
                        TaskTimer timer = ((TimedFutureTask)command).getTimer();
                        try {
                            timer.offer(executor.getQueue(), command);
                            break block9;
                        }
                        catch (TimeoutException te) {
                            throw new RejectedExecutionException(String.format("Attempt to queue task %s timed out.  Original message: %s", command, te.getMessage()));
                        }
                    }
                    executor.getQueue().put(command);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RejectedExecutionException(String.format("Attempt to queue task %s after rejection interrupted.", command));
                }
            }
        }
    }
}

